package com.wewebu.ow.server.ecmimpl.cmis.object;

import java.util.Collection;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSimpleDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;

/**
 *<p>
 * OwCMISRepositoryObject represents a repository.
 * This object automatically creates a {@link OwCMISRepositoryFolder} which
 * represent the root of the repository.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISRepositoryObject implements OwObject
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwCMISRepositoryObject.class);

    private OwCMISNetwork network;
    private OwCMISResource resource;
    private OwObjectClass objectClass;

    private OwCMISRepositoryFolder rootFolder;

    public OwCMISRepositoryObject(OwCMISNetwork network_p, OwCMISResource res_p) throws OwException
    {
        this.network = network_p;
        this.resource = res_p;
        objectClass = new OwStandardObjectClass();
        rootFolder = new OwCMISRepositoryFolder(network_p, res_p.getObjectModel());
    }

    public void add(OwObject oObject_p) throws Exception
    {

    }

    public boolean canAdd(OwObject oObject_p, int iContext_p) throws OwException
    {
        return rootFolder.canAdd(oObject_p, iContext_p);
    }

    public boolean canChangeClass() throws OwException
    {
        return false;
    }

    public boolean canDelete(int iContextP_p) throws OwException
    {
        return false;
    }

    public boolean canFilterChilds() throws OwException
    {
        return false;
    }

    public boolean canGetContent(int iContentTypeP_p, int iContextP_p) throws OwException
    {
        return false;
    }

    public boolean canGetPermissions() throws OwException
    {
        return false;
    }

    public boolean canGetProperties(int iContextP_p) throws OwException
    {
        return false;
    }

    public boolean canLock() throws OwException
    {
        return false;
    }

    public boolean canMove(OwObject oObjectP_p, OwObject oldParentP_p, int iContextP_p) throws OwException
    {
        return false;
    }

    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws OwException
    {
        return false;
    }

    public boolean canSetContent(int iContentType_p, int iContext_p) throws OwException
    {
        return this.rootFolder.canSetContent(iContentType_p, iContext_p);
    }

    public boolean canSetPermissions() throws OwException
    {
        return false;
    }

    public boolean canSetProperties(int iContextP_p) throws OwException
    {
        return false;
    }

    public void changeClass(String strNewClassNameP_p, OwPropertyCollection propertiesP_p, OwPermissionCollection permissionsP_p) throws OwException
    {

    }

    public void delete() throws OwException
    {

    }

    public int getChildCount(int[] iObjectTypesP_p, int iContextP_p) throws OwException
    {
        //        return 1;
        throw new OwStatusContextException("Not implemented");
    }

    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws OwException
    {
        //Search beginning from the root folder of this repository, delegate rootFolder instance
        return rootFolder.getChilds(iObjectTypes_p, propertyNames_p, sort_p, iMaxSize_p, iVersionSelection_p, filterCriteria_p);
    }

    public String getClassName()
    {
        return null;
    }

    public OwPermissionCollection getClonedPermissions() throws OwException
    {
        return null;
    }

    public OwPropertyCollection getClonedProperties(Collection propertyNamesP_p) throws OwException
    {
        return null;
    }

    public Collection getColumnInfoList() throws OwException
    {
        return null;
    }

    public OwContentCollection getContentCollection() throws OwException
    {
        return null;
    }

    public Collection getFilterProperties(Collection propertynamesP_p) throws OwException
    {
        return null;
    }

    public boolean getLock(int iContextP_p) throws OwException
    {
        return false;
    }

    public String getLockUserID(int iContextP_p) throws OwException
    {
        return null;
    }

    public boolean getMyLock(int iContextP_p) throws OwException
    {
        return false;
    }

    public Object getNativeObject() throws OwException
    {
        return null;
    }

    public OwObjectClass getObjectClass()
    {
        return this.objectClass;
    }

    public OwObjectCollection getParents() throws OwException
    {
        return null;
    }

    public String getPath() throws OwException
    {
        return null;
    }

    public OwPermissionCollection getPermissions() throws OwException
    {
        return null;
    }

    public OwPropertyCollection getProperties(Collection propertyNames_p) throws OwException
    {
        return null;
    }

    public OwProperty getProperty(String strPropertyName_p) throws OwException
    {
        if (OwResource.m_ObjectNamePropertyClass.getClassName().equals(strPropertyName_p))
        {
            return new OwStandardProperty(getName(), OwResource.m_ObjectNamePropertyClass);
        }
        throw new OwObjectNotFoundException("Property " + strPropertyName_p + " not exist in this context.");
    }

    public OwResource getResource() throws OwException
    {
        return this.resource;
    }

    public OwSearchTemplate getSearchTemplate() throws OwException
    {
        return null;
    }

    public OwVersion getVersion() throws OwException
    {
        // TODO Auto-generated method stub
        return null;
    }

    public OwVersionSeries getVersionSeries() throws OwException
    {
        // TODO Auto-generated method stub
        return null;
    }

    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws OwException
    {
        for (int i : iObjectTypes_p)
        {
            if (i == OwObjectReference.OBJECT_TYPE_ALL_CONTAINER_OBJECTS || i == OwObjectReference.OBJECT_TYPE_ECM_ROOT_FOLDER || i == OwObjectReference.OBJECT_TYPE_FOLDER)
            {
                return true;
            }
        }
        return false;
    }

    public boolean hasVersionSeries() throws OwException
    {
        return false;
    }

    public void move(OwObject oObject_p, OwObject oldParent_p) throws OwException
    {

    }

    public void refreshProperties() throws OwException
    {

    }

    public void refreshProperties(Collection props_p) throws OwException
    {

    }

    public void removeReference(OwObject oObject_p) throws OwException
    {

    }

    public void setContentCollection(OwContentCollection content_p) throws OwException
    {
        LOG.error("OwCMISRepositoryObject.setContentCollection():Unsupported operation! Inavlid set content request for a repository object!");
        throw new OwInvalidOperationException(getNetwork().getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public boolean setLock(boolean fLock_p) throws OwException
    {
        return false;
    }

    public void setPermissions(OwPermissionCollection permissions_p) throws OwException
    {

    }

    public void setProperties(OwPropertyCollection properties_p) throws OwException
    {

    }

    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws OwException
    {

    }

    public String getDMSID() throws OwException
    {
        return OwCMISSimpleDMSID.createDMSID(this.network.getDMSPrefix(), this.resource.getID(), this.rootFolder.getID());
    }

    public String getID()
    {
        try
        {
            return this.resource.getID() + ',' + this.rootFolder.getID();
        }
        catch (OwException e)
        {
            return this.rootFolder.getID();
        }
    }

    public OwObject getInstance() throws OwException
    {
        return this;
    }

    public String getMIMEParameter() throws OwException
    {
        return null;
    }

    public String getMIMEType() throws OwException
    {
        return "ow_root/cmis_obst";
    }

    public String getName()
    {
        return this.resource.getDisplayName(network.getLocale());
    }

    public int getPageCount() throws OwException
    {
        return 0;
    }

    public String getResourceID() throws OwException
    {
        return this.resource.getID();
    }

    public int getType()
    {
        return OwObjectReference.OBJECT_TYPE_ECM_ROOT_FOLDER;
    }

    public boolean hasContent(int iContext_p) throws OwException
    {
        return false;
    }

    public OwField getField(String strFieldClassName_p) throws OwException, OwObjectNotFoundException
    {
        return null;
    }

    public String getFieldProviderName()
    {
        return null;
    }

    public Object getFieldProviderSource()
    {
        return null;
    }

    public int getFieldProviderType()
    {
        return 0;
    }

    public Collection getFields() throws OwException
    {
        return null;
    }

    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p)
    {
        return null;
    }

    public void setField(String sName_p, Object value_p) throws OwException, OwObjectNotFoundException
    {

    }

    /**
     * Get method for used adapter.
     * @return OwCMISNetwork
     */
    protected OwCMISNetwork getNetwork()
    {
        return this.network;
    }
}