package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISObjectClassDescription;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISObjectName;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISObjectPath;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * Workdesk CMIS object class hierarchy base class.<br>
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISBaseClass implements OwCMISObjectClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISBaseClass.class);

    public static final String DEFAULT_BASE_CLASS_NAME = "owd:base";

    private OwCMISClassDescription classDescription;
    private OwCMISPropertyClassFactory propertyClassFactory;
    private OwCMISObjectModel objectModel;
    private String className;

    public OwCMISBaseClass(OwCMISObjectModel objectModel_p, OwCMISPropertyClassFactory propertyClassFactory_p)
    {
        this(DEFAULT_BASE_CLASS_NAME, objectModel_p, propertyClassFactory_p);
    }

    public OwCMISBaseClass(String className_p, OwCMISObjectModel objectModel_p, OwCMISPropertyClassFactory propertyClassFactory_p)
    {
        super();
        this.className = className_p;
        this.objectModel = objectModel_p;
        this.propertyClassFactory = propertyClassFactory_p;
        this.classDescription = new OwCMISClassDescription(this, null);

        OwCMISObjectName objectName = new OwCMISObjectName(this);
        OwCMISObjectClassDescription objectClassDescription = new OwCMISObjectClassDescription(this);
        OwCMISObjectPath objectPath = new OwCMISObjectPath(this);
        this.classDescription.addLocalPropertyClass(objectName);
        this.classDescription.addLocalPropertyClass(objectClassDescription);
        this.classDescription.addLocalPropertyClass(objectPath);
    }

    protected OwCMISObjectModel getObjectModel()
    {
        return this.objectModel;
    }

    protected OwCMISPropertyClassFactory getPropertyClassFactory()
    {
        return this.propertyClassFactory;
    }

    public OwCMISObject createCMISObject(OwCMISNetwork network_p, CmisObjectType object_p, boolean preserveVersion_p) throws OwException
    {
        String msg = "Unsupported CMIS adapter object operation!Create new Object currently does not support type : " + getType() + " in object class " + getClassName() + " implemented by " + getClass();
        LOG.error("OwCMISVirtualBaseClass.createNewObjectCMISObject():" + msg);
        throw new OwNotSupportedException(network_p.getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public String createNewObject(OwCMISNetwork network_p, boolean promote_p, Object mode_p, OwResource resource_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p,
            String strMimeType_p, String strMimeParameter_p, boolean keepCheckedOut_p) throws OwException
    {
        String msg = "Unsupported CMIS adapter object operation!Create new Object currently does not support type : " + getType() + " in object class " + getClassName() + " implemented by " + getClass();
        LOG.error("OwCMISVirtualBaseClass.createNewObjectCMISObject():" + msg);
        throw new OwNotSupportedException(network_p.getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public String getMimetype()
    {
        return null;
    }

    public OwCMISPropertyClass getPropertyClass(String strClassName_p) throws OwException
    {
        return this.classDescription.getPropertyClass(strClassName_p);
    }

    public Collection<String> getPropertyClassNames() throws OwException
    {
        return getPropertyClasses().keySet();
    }

    public Map<String, OwCMISPropertyClass> getPropertyClasses() throws OwException
    {
        return this.classDescription.getPropertyClasses();
    }

    public String getQueryName()
    {
        return getClassName();
    }

    public Set<OwCMISPropertyClass> getQueryablePropertyClasses(OwCMISQueryContext context_p) throws OwException
    {
        return this.classDescription.getQueryablePropertyClasses(context_p);
    }

    public OwCMISResource getResource()
    {
        return this.objectModel.getResource();
    }

    public boolean isContentRequired() throws OwException
    {
        return false;
    }

    public boolean isQueryable()
    {
        return false;
    }

    public boolean canCreateNewObject() throws OwException
    {
        return false;
    }

    public Map<String, OwCMISObjectClass> getChildNames(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p) throws Exception
    {
        return this.classDescription.getNamedSubclasses(excludeHiddenAndNonInstantiable_p);
    }

    public List<OwCMISObjectClass> getChilds(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p) throws Exception
    {
        return this.classDescription.getSubclasses(excludeHiddenAndNonInstantiable_p);
    }

    public String getClassName()
    {
        return this.className;
    }

    public String getDescription(Locale locale_p)
    {
        return OwString.localizeLabel(locale_p, "ecmimpl.cmis.virtualBaseObject.description", "Virtual Base Object");
    }

    public String getDisplayName(Locale locale_p)
    {
        return OwString.localizeLabel(locale_p, "ecmimpl.cmis.virtualBaseObject.display.name", "Virtual Base Object");
    }

    public List<?> getModes(int operation_p) throws Exception
    {
        return null;
    }

    public String getNamePropertyName() throws OwException
    {
        return OwResource.m_ObjectNamePropertyClass.getClassName();
    }

    public OwCMISObjectClass getParent() throws OwException
    {
        return null;
    }

    public int getType()
    {
        return OwObjectReference.OBJECT_TYPE_CUSTOM;
    }

    public boolean hasChilds(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p, int context_p) throws Exception
    {
        List<OwCMISObjectClass> subclasses = this.classDescription.getSubclasses(excludeHiddenAndNonInstantiable_p);
        return !subclasses.isEmpty();
    }

    public boolean hasVersionSeries() throws Exception
    {
        return false;
    }

    public boolean isHidden() throws Exception
    {
        return true;
    }

    public void subclassedBy(OwCMISObjectClass subclass_p) throws OwInvalidOperationException
    {
        this.classDescription.subclassedBy(subclass_p);
    }

    public boolean isAssignableFrom(OwCMISObjectClass class_p) throws OwException
    {
        OwCMISResource resource = getResource();
        OwCMISResource classResource = class_p.getResource();

        return resource.getID().equals(classResource.getID());
    }

    public CmisTypeDefinitionType getNativeObject()
    {
        return null;
    }
}
