package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlListType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDocumentDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumVersioningState;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISDocumentObject;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.version.OwCMISVersionModel;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISContentHandler;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISDocumentClass.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISDocumentClass extends OwCMISNativeObjectClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISDocumentClass.class);

    public OwCMISDocumentClass(OwCMISObjectModel objectModel_p, OwCMISPropertyClassFactory propertyClassFactory_p, CmisTypeDocumentDefinitionType type_p) throws OwException
    {
        super(objectModel_p, propertyClassFactory_p, type_p);
    }

    public String getMimetype()
    {
        return null;
    }

    @Override
    public boolean canCreateNewObject() throws OwException
    {
        return Boolean.TRUE.booleanValue();
    }

    public boolean hasVersionSeries() throws OwException
    {
        return getNativeObject().isVersionable();
    }

    @Override
    public CmisTypeDocumentDefinitionType getNativeObject()
    {
        return (CmisTypeDocumentDefinitionType) super.getNativeObject();
    }

    public OwCMISDocumentObject createCMISObject(OwCMISNetwork network_p, CmisObjectType object_p, boolean preserveVersion_p) throws OwException
    {
        CmisObjectType owdVersion = object_p;
        OwCMISObjectModel objectModel = getObjectModel();
        if (!preserveVersion_p)
        {
            OwCMISVersionModel versionModel = objectModel.getVersionModel();

            owdVersion = versionModel.retriveOWDObjectVersion(network_p, getResource().getID(), object_p);
        }

        return new OwCMISDocumentObject(network_p, objectModel, owdVersion);
    }

    @Override
    protected String createNewObjectCMISObject(OwCMISNetwork network_p, EnumVersioningState state_p, CmisPropertiesType properties_p, CmisAccessControlListType addedACL_p, CmisAccessControlListType removedACL_p, CmisContentStreamType content_p,
            String parentID_p, boolean keepCheckedOut_p) throws OwException
    {
        try
        {
            Holder<String> newID = new Holder<String>();
            newID.value = "";
            ObjectServicePort objectServicePort = network_p.getObjectServicePort();

            //Fix for metro JAX-WS RI: Handling of big attachment.
            BindingProvider bindingProvider = (BindingProvider) objectServicePort;
            OwCMISContentHandler.setAttachmentToContext(content_p, bindingProvider);

            objectServicePort.createDocument(getResource().getID(), properties_p, parentID_p, content_p, state_p, null, addedACL_p, removedACL_p, null, newID);
            return newID.value;
        }
        catch (CmisException e)
        {
            OwNetworkContext context = network_p.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISDocumentClass.createNewObjectCMISObject(): Could not create document ! A CMIS error occurred : " + catcher.getLogMessage());
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISDocumentClass.createNewObjectCMISObject.error", "Could not create document!"), true);
        }
    }

}
