package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import javax.xml.ws.Holder;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlListType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumVersioningState;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISFolderObject;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISRepositoryFolder;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISFolderClass.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISFolderClass extends OwCMISNativeObjectClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISFolderClass.class);

    public OwCMISFolderClass(OwCMISObjectModel objectModel_p, OwCMISPropertyClassFactory propertyClassFactory_p, CmisTypeDefinitionType type_p) throws OwException
    {
        super(objectModel_p, propertyClassFactory_p, type_p);
    }

    @Override
    public boolean canCreateNewObject() throws OwException
    {
        return Boolean.TRUE.booleanValue();
    }

    public OwCMISObjectBase createCMISObject(OwCMISNetwork network_p, CmisObjectType object_p, boolean preserveVersion_p) throws OwException
    {
        if (getObjectModel().getResource().getRepsitoryRootFolderId().equals(OwCMISPropertyNames.OBJECT_ID.getIdValue(object_p)))
        {
            return new OwCMISRepositoryFolder(network_p, getObjectModel());
        }
        else
        {
            return new OwCMISFolderObject(network_p, getObjectModel(), object_p);
        }
    }

    @Override
    protected String createNewObjectCMISObject(OwCMISNetwork network_p, EnumVersioningState state_p, CmisPropertiesType properties_p, CmisAccessControlListType addedACL_p, CmisAccessControlListType removedACL_p, CmisContentStreamType content_p,
            String parentID_p, boolean keepCheckedOut_p) throws OwException
    {
        try
        {
            Holder<String> newID = new Holder<String>();
            newID.value = "";
            ObjectServicePort objectServicePort = network_p.getObjectServicePort();
            objectServicePort.createFolder(getResource().getID(), properties_p, parentID_p, null, addedACL_p, removedACL_p, null, newID);
            return newID.value;
        }
        catch (CmisException e)
        {
            OwNetworkContext context = network_p.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISFolderClass.createNewObjectCMISObject(): Could not create folder ! A CMIS error occurred : " + catcher.getLogMessage());
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISFolderClass.createNewObjectCMISObject.error", "Could not create folder !"), true);
        }
    }

    //    @Override
    //    protected Set<OwCMISPropertyClass> createCustomPropertyClasses() throws OwException
    //    {
    //        Set<OwCMISPropertyClass> superCustomProperties = super.createCustomPropertyClasses();
    //        OwCMISPropertyClass nativePathPropertyClass = getPropertyClass(OwCMISPropertyNames.PATH.getId());
    //
    //        OwCMISPropertyClass pathPropertyClass = new OwCMISMappedInternalPropertyClass(OwResource.m_ObjectPathPropertyClass, this, nativePathPropertyClass);
    //        superCustomProperties.add(pathPropertyClass);
    //
    //        return superCustomProperties;
    //
    //    }

    public boolean hasVersionSeries() throws Exception
    {
        return false;
    }

}
