package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;

/**
 *<p>
 * Base interface for all object classes.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISObjectClass extends OwObjectClass
{
    static final String MIME_TYPE_PREFIX_OW_RELATIONSHIP = "ow_relationship/";

    static final String MIME_TYPE_PREFIX_OW_POLICY = "ow_policy/";

    String getMimetype();

    OwCMISPropertyClass getPropertyClass(String strClassName_p) throws OwException;

    Collection<String> getPropertyClassNames() throws OwException;

    /**
     * 
     * @return a {@link Map} of property classes fully qualified names mapped to {@link OwCMISPropertyClass} 
     *         for all properties defined by this object class (inherited properties included).
     * @throws OwException
     */
    Map<String, OwCMISPropertyClass> getPropertyClasses() throws OwException;

    OwCMISObjectClass getParent() throws OwException;

    /**
     * Define if for this object the content is required.
     * @return boolean true if is required, otherwise false
     * @throws OwException
     */
    boolean isContentRequired() throws OwException;

    /**
     * As specified by the CMIS definition, the request
     * method to verify if this object can be used in query FROM statement.
     * @return boolean query able 
     */
    boolean isQueryable();

    /**
     * Should return an non-null value if this object is
     * query able.
     * @return String escaped query name, which MUST be used for searches
     */
    String getQueryName();

    /**
     * Creates an {@link OwCMISObject} for the given native {@link CmisObjectType}
     * @param network_p
     * @param object_p
     * @param preserveVersion_p boolean, true if the exact version should be used 
     * @return the {@link OwCMISObject} corresponding to the given {@link CmisObjectType}
     * @throws OwException
     */
    OwCMISObject createCMISObject(OwCMISNetwork network_p, CmisObjectType object_p, boolean preserveVersion_p) throws OwException;

    /**
     * 
     * @param promote_p
     * @param mode_p
     * @param resource_p
     * @param properties_p
     * @param permissions_p
     * @param content_p
     * @param parent_p
     * @param strMimeType_p
     * @param strMimeParameter_p
     * @param keepCheckedOut_p
     * @return a String DMSID for the newly created object 
     * @throws OwException
     */
    String createNewObject(OwCMISNetwork network_p, boolean promote_p, Object mode_p, OwResource resource_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p,
            String strMimeType_p, String strMimeParameter_p, boolean keepCheckedOut_p) throws OwException;

    /**
     * 
     * @return the resource that this class associates with 
     */
    OwCMISResource getResource();

    /**
     * 
     * @return a {@link Set} of {@link OwCMISPropertyClass} for all queryable property classes that are defined 
     *         by this object class
     * @throws OwException
     */
    Set<OwCMISPropertyClass> getQueryablePropertyClasses(OwCMISQueryContext context_p) throws OwException;

    String getNamePropertyName() throws OwException;

    /**
     * Method called when this class is sub-classed. 
     * @param subclass_p the new child of this class 
     * @throws OwInvalidOperationException if the subclass constraints of this class are not met or
     *                                     the this class can not be sub-classed  
     */
    void subclassedBy(OwCMISObjectClass subclass_p) throws OwInvalidOperationException;

    /**
     * A java class analogous method : 
     * Determines if the object-class represented by this object-class object is either the same as, or is a superclass 
     * of the object-class represented by the specified object-class parameter.
     * @param class_p
     * @return the boolean value indicating whether objects of the type class can be interpreted as objects of this class 
     * @throws OwException
     * @since 3.1.0.0
     */
    boolean isAssignableFrom(OwCMISObjectClass class_p) throws OwException;

    boolean canCreateNewObject() throws OwException;

    /**
     * Return the native representation type of current objectclass.
     * <p>Attention: Can return null if this object is not based on
     * a native representation, but a local structure object.</p>
     * @return CmisTypeDefinitionType or null
     * @since 3.2.0.0
     */
    CmisTypeDefinitionType getNativeObject();
}
