package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Standard CMIS class factory interface.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISObjectClassFactory
{
    OwCMISObjectClass createClass(CmisTypeDefinitionType typeDefinition_p, OwCMISObjectModel objectModel_p) throws OwException;

    OwCMISObjectClass createVirtualBaseClass(OwCMISObjectModel objectModel_p) throws OwException;

    /**
     * Set list of preferred property order, which should be
     * provided to the generated objects.
     * @param propertyOrder_p List of Strings
     * @since 4.0.0.0
     */
    void setPreferredPropertyOrder(List<String> propertyOrder_p);
}