package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlListType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumVersioningState;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISPolicyObject;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;

/**
 *<p>
 * OwCMISPolicyClass.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPolicyClass extends OwCMISNativeObjectClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISPolicyClass.class);

    public OwCMISPolicyClass(OwCMISObjectModel objectModel_p, OwCMISPropertyClassFactory propertyClassFactory_p, CmisTypeDefinitionType type_p) throws OwException
    {
        super(objectModel_p, propertyClassFactory_p, type_p);
    }

    public String getMimetype()
    {
        return OwCMISObjectClass.MIME_TYPE_PREFIX_OW_POLICY + getClassName();
    }

    public OwCMISObjectBase createCMISObject(OwCMISNetwork network_p, CmisObjectType object_p, boolean preserveVersion_p) throws OwException
    {
        return new OwCMISPolicyObject(network_p, getObjectModel(), object_p);
    }

    @Override
    protected String createNewObjectCMISObject(OwCMISNetwork network_p, EnumVersioningState state_p, CmisPropertiesType properties_p, CmisAccessControlListType addedACL_p, CmisAccessControlListType removedACL_p, CmisContentStreamType content_p,
            String parentID_p, boolean keepCheckedOut_p) throws OwException
    {
        String msg = "Unsupported CMIS adapter object operation!Create new Object currently does not support type : " + getType() + " in object class " + getClassName() + " implemented by " + getClass();
        LOG.error("OwCMISPolicyClass.createNewObjectCMISObject():" + msg);
        throw new OwNotSupportedException(network_p.getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public boolean hasVersionSeries() throws Exception
    {
        return false;
    }
}
