package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import java.util.List;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDocumentDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumBaseObjectTypeIds;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;

/**
 *<p>
 * Standard CMIS class factory.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISStandardObjectClassFactory implements OwCMISObjectClassFactory
{
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardObjectClassFactory.class);

    private OwCMISPropertyClassFactory propertyClassFactory;
    private List<String> propertyOrder;

    public OwCMISStandardObjectClassFactory(OwCMISPropertyClassFactory propertyClassFactory_p)
    {
        super();
        this.propertyClassFactory = propertyClassFactory_p;
    }

    public OwCMISStandardObjectClassFactory(OwCMISPropertyClassFactory propertyClassFactory_p, List<String> propertyOrder_p)
    {
        this(propertyClassFactory_p);
        this.propertyOrder = propertyOrder_p;
    }

    public OwCMISNativeObjectClass createClass(CmisTypeDefinitionType typeDefinition_p, OwCMISObjectModel objectModel_p) throws OwException
    {
        EnumBaseObjectTypeIds baseID = typeDefinition_p.getBaseId();
        OwCMISNativeObjectClass objectClass;
        switch (baseID)
        {
            case CMIS_DOCUMENT:
                objectClass = new OwCMISDocumentClass(objectModel_p, this.propertyClassFactory, (CmisTypeDocumentDefinitionType) typeDefinition_p);
                break;
            case CMIS_FOLDER:
                objectClass = new OwCMISFolderClass(objectModel_p, this.propertyClassFactory, typeDefinition_p);
                break;
            case CMIS_POLICY:
                objectClass = new OwCMISPolicyClass(objectModel_p, this.propertyClassFactory, typeDefinition_p);
                break;
            case CMIS_RELATIONSHIP:
                objectClass = new OwCMISRelationshipClass(objectModel_p, this.propertyClassFactory, typeDefinition_p);
                break;
            default:
            {
                LOG.error("OwCMISStandardObjectClassFactory.createClass(): Unknown base ID from CMIS Respository: " + baseID);
                throw new OwServerException("Invalid base ID " + baseID);
            }
        }
        if (objectClass != null)
        {
            objectClass.getClassDescription().setPreferredPropertyOrder(getPreferredPropertyOrder());
        }
        return objectClass;
    }

    public OwCMISObjectClass createVirtualBaseClass(OwCMISObjectModel objectModel_p) throws OwException
    {
        return new OwCMISBaseClass(objectModel_p, this.propertyClassFactory);
    }

    public void setPreferredPropertyOrder(List<String> propertyOrder)
    {
        this.propertyOrder = propertyOrder;
    }

    /**
     * Get preferred property order list.
     * @return List of Strings, or null if not set
     * @since 4.0.0.0
     */
    public List<String> getPreferredPropertyOrder()
    {
        return propertyOrder;
    }

}
