package com.wewebu.ow.server.ecmimpl.cmis.permissions;

import java.util.Collection;
import java.util.Collections;

import org.oasis_open.docs.ns.cmis.core._200908.CmisPermissionDefinition;

import com.wewebu.ow.server.ecm.OwPrivilege;

/**
 *<p>
 * CMIS based privilege implementation. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public class OwCMISPrivilege implements OwPrivilege
{
    private CmisPermissionDefinition permissionDefinition;

    public OwCMISPrivilege(CmisPermissionDefinition permissionDefinition_p)
    {
        super();
        this.permissionDefinition = permissionDefinition_p;
    }

    public String getName()
    {
        return permissionDefinition.getPermission();
    }

    public String getDescription()
    {
        return permissionDefinition.getDescription();
    }

    public Collection getChilds(boolean recursive_p)
    {
        return Collections.EMPTY_LIST;
    }

    public boolean hasChilds()
    {
        return false;
    }

}
