package com.wewebu.ow.server.ecmimpl.cmis.permissions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlEntryType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlPrincipalType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPermissionDefinition;

import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;

/**
 *<p>
 * CMIS {@link CmisAccessControlEntryType} based privilege set implementation. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public class OwCMISPrivilegeSet implements OwPrivilegeSet
{

    private static final Logger LOG = OwLog.getLogger(OwCMISPrivilegeSet.class);

    private CmisAccessControlEntryType accessControlEntry;
    private Map<String, OwPrivilege> availablePrivileges;

    public OwCMISPrivilegeSet(CmisAccessControlEntryType accessControlEntry_p, Map<String, OwPrivilege> availablePrivileges_p)
    {
        super();
        this.accessControlEntry = accessControlEntry_p;
        this.availablePrivileges = availablePrivileges_p;
    }

    public OwUserInfo getPrincipal()
    {
        CmisAccessControlPrincipalType principal = accessControlEntry.getPrincipal();
        return new OwCMISACLPrincipal(principal);
    }

    public boolean isDenied()
    {
        return false;
    }

    public Collection<OwPrivilege> getPrivileges()
    {
        List<OwPrivilege> privileges = new LinkedList<OwPrivilege>();
        List<String> acePermissions = accessControlEntry.getPermission();
        for (String acePermission : acePermissions)
        {
            OwPrivilege privilege = availablePrivileges.get(acePermission);
            if (privilege == null)
            {
                CmisAccessControlPrincipalType principal = accessControlEntry.getPrincipal();
                LOG.error("Invalid privilege found " + acePermission + " for principal " + principal.getPrincipalId());
                CmisPermissionDefinition nullDefinition = new CmisPermissionDefinition();
                nullDefinition.setPermission(acePermission);
                nullDefinition.setDescription(acePermission);

                privilege = new OwCMISPrivilege(nullDefinition);

            }

            privileges.add(privilege);

        }

        return privileges;
    }

    public int getInheritanceDepth()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        String principal = "<null>";
        String privileges = "<null>";
        if (accessControlEntry != null)
        {
            principal = accessControlEntry.getPrincipal().getPrincipalId();
            privileges = accessControlEntry.getPermission().toString();
        }
        return "CMISPrivilegeSet[" + principal + "->" + privileges + "]";
    }
}
