package com.wewebu.ow.server.ecmimpl.cmis.property;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Implementors are used by {@link OwCMISStandardPropertyCollectionConverter} to filter out  properties 
 * that are not accepted for conversion. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public interface OwCMISConvertFilter
{
    /**
     * 
     * @param cmisProperty_p
     * @return true if the given property can be converted 
     * @throws OwException
     */
    boolean accept(OwProperty cmisProperty_p) throws OwException;
}