package com.wewebu.ow.server.ecmimpl.cmis.property;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Chain of responsibility filter base class.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public abstract class OwCMISConvertFilterChain implements OwCMISConvertFilter
{
    private OwCMISConvertFilter nextFilter;

    public OwCMISConvertFilterChain()
    {
        this(null);
    }

    public OwCMISConvertFilterChain(OwCMISConvertFilter nextFilter_p)
    {
        super();
        this.nextFilter = nextFilter_p;
    }

    public boolean accept(OwProperty property_p) throws OwException
    {
        return nextFilter == null ? true : nextFilter.accept(property_p);
    }

}
