package com.wewebu.ow.server.ecmimpl.cmis.property;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Filters properties that are extensions of {@link OwCMISInternalProperty}.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class OwCMISFilterInternal extends OwCMISConvertFilterChain
{

    public OwCMISFilterInternal()
    {
        this(null);
    }

    public OwCMISFilterInternal(OwCMISConvertFilter nextFilter_p)
    {
        super(nextFilter_p);
    }

    @Override
    public boolean accept(OwProperty property_p) throws OwException
    {

        if (property_p instanceof OwCMISInternalProperty)
        {
            return false;
        }
        else
        {
            return super.accept(property_p);
        }
    }
}
