package com.wewebu.ow.server.ecmimpl.cmis.property;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;

/**
 *<p>
 * Filters properties based on the read only attribute of given properties or of their classes.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class OwCMISFilterReadonly extends OwCMISConvertFilterChain
{
    private int context;

    public OwCMISFilterReadonly(int context_p)
    {
        this(null, context_p);
    }

    public OwCMISFilterReadonly(OwCMISConvertFilter nextFilter_p, int context_p)
    {
        super(nextFilter_p);
        this.context = context_p;
    }

    @Override
    public boolean accept(OwProperty property_p) throws OwException
    {
        try
        {
            OwPropertyClass clazz = property_p.getPropertyClass();
            if (!clazz.isReadOnly(context))
            {
                return super.accept(property_p);
            }
            else
            {
                return false;
            }
        }
        catch (Exception e)
        {
            throw new OwInvalidOperationException("Filter error", e);
        }

    }
}
