package com.wewebu.ow.server.ecmimpl.cmis.property;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISInternalPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISMappedInternalProperty.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISMappedInternalProperty extends OwCMISInternalProperty
{
    private static final Logger LOG = OwLog.getLogger(OwCMISMappedInternalProperty.class);

    private OwCMISProperty mappedProperty;

    public OwCMISMappedInternalProperty(OwCMISObject ownerObject_p, OwCMISInternalPropertyClass internalPropertyClass_p, OwCMISProperty mappedProperty_p)
    {
        super(ownerObject_p, internalPropertyClass_p);
        this.mappedProperty = mappedProperty_p;
    }

    @Override
    public synchronized void addTo(CmisPropertiesType cmisPropertiesType_p) throws OwException
    {
        this.mappedProperty.addTo(cmisPropertiesType_p);
    }

    public Object getNativeObject() throws Exception
    {
        return this.mappedProperty.getNativeObject();
    }

    public Object getValue() throws OwException
    {
        return this.mappedProperty.getValue();
    }

    public void setValue(Object value_p) throws OwException
    {
        this.mappedProperty.setValue(value_p);
    }

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder("cmis-property(internal-mapped,");
        builder.append(getPropertyClass().toString());
        builder.append("),");
        Object value = "<err-value>";
        try
        {
            value = getValue();
            if (value == null)
            {
                value = "<null-value>";
            }
        }
        catch (OwException e)
        {
            LOG.error("Could not retrieve value!", e);
        }
        builder.append("value=");
        builder.append(value.toString());
        builder.append(")");
        return builder.toString();
    }
}
