package com.wewebu.ow.server.ecmimpl.cmis.property;

import java.util.List;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Property wrapper for native CMIS property objects.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public abstract class OwCMISNativeProperty extends OwCMISProperty
{
    private static final Logger LOG = OwLog.getLogger(OwCMISNativeProperty.class);

    public OwCMISNativeProperty(OwCMISNativePropertyClass owPropertyClass_p)
    {
        super(owPropertyClass_p);
    }

    public OwCMISNativePropertyClass getPropertyClass()
    {
        return (OwCMISNativePropertyClass) super.getPropertyClass();
    }

    public abstract CmisProperty getNativeObject();

    @Override
    public void addTo(CmisPropertiesType cmisPropertiesType_p)
    {
        List<CmisProperty> livePropertyList = cmisPropertiesType_p.getProperty();
        livePropertyList.add(getNativeObject());
    }

    public boolean isHidden(int context_p) throws OwException
    {
        return getPropertyClass().isHidden(context_p);
    }

    public boolean isReadOnly(int context_p) throws OwException
    {
        return getPropertyClass().isReadOnly(context_p);
    }

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder("cmis-property(native,");
        builder.append(getPropertyClass().toString());
        builder.append("),");
        Object value = "<err-value>";
        try
        {
            value = getValue();
            if (value == null)
            {
                value = "<null-value>";
            }
        }
        catch (OwException e)
        {
            LOG.error("Could not retrieve value!", e);
        }
        builder.append("value=");
        builder.append(value.toString());
        builder.append(")");
        return builder.toString();
    }
}