package com.wewebu.ow.server.ecmimpl.cmis.property;

import java.util.List;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;

import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISLiveListHandler;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISNativePropertyBinding;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;

/**
 *<p>
 * OwCMISNativePropertyTemplate.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISNativePropertyTemplate<L, O> extends OwCMISNativeProperty
{
    private static final Logger LOG = OwLog.getLogger(OwCMISNativePropertyTemplate.class);

    private OwCMISNativePropertyBinding<L> propertyBinding;
    private OwCMISLiveListHandler<L, O> liveListHandler;
    private OwCMISValueConverter<L, O> valueConverter;

    public OwCMISNativePropertyTemplate(OwCMISNativePropertyBinding<L> propertyBinding_p, OwCMISValueConverter<L, O> valueConverter_p, OwCMISNativePropertyClass owPropertyClass_p)
    {
        super(owPropertyClass_p);
        this.liveListHandler = new OwCMISLiveListHandler<L, O>(valueConverter_p);
        this.valueConverter = valueConverter_p;
        this.propertyBinding = propertyBinding_p;
    }

    @Override
    public void setValue(Object value_p) throws OwException
    {
        List<L> liveValueList = this.propertyBinding.getLiveValueList();
        OwCMISNativePropertyClass propertyClass = getPropertyClass();
        try
        {
            this.liveListHandler.replaceListValues(liveValueList, value_p, propertyClass.isArray());
        }
        catch (OwException e)
        {
            LOG.error("Could not set value for : " + getPropertyClass().getClassName());
            throw new OwInvalidOperationException("Could not set value for : " + getPropertyClass().getClassName(), e);
        }
    }

    @Override
    public Object getValue() throws OwException
    {
        List<L> liveValueList = this.propertyBinding.getLiveValueList();
        OwCMISNativePropertyClass propertyClass = getPropertyClass();
        try
        {
            return liveListHandler.extractValue(liveValueList, propertyClass.isArray());
        }
        catch (OwException e)
        {
            throw new OwInvalidOperationException("Could not retrieve value of " + propertyClass.getClassName(), e);
        }
    }

    @Override
    public CmisProperty getNativeObject()
    {
        return this.propertyBinding.getNativeProperty();
    }

    @Override
    public Object clone() throws CloneNotSupportedException
    {
        OwCMISNativePropertyBinding<L> bindingClone = this.propertyBinding.cloneBinding();
        OwCMISNativePropertyClass propertyClass = getPropertyClass();
        return new OwCMISNativePropertyTemplate<L, O>(bindingClone, this.valueConverter, propertyClass);
    }
}
