package com.wewebu.ow.server.ecmimpl.cmis.property;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyComparator;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwFieldDefinition;

/**
 *<p>
 * OwCMISProperty.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public abstract class OwCMISProperty implements OwProperty, Cloneable
{
    private static final Logger LOG = OwLog.getLogger(OwCMISProperty.class);

    private OwCMISPropertyClass m_propertyclass;

    public OwCMISProperty(OwCMISPropertyClass owPropertyClass_p)
    {

        m_propertyclass = owPropertyClass_p;
    }

    public Object clone() throws CloneNotSupportedException
    {
        return super.clone();
    }

    public OwCMISPropertyClass getPropertyClass()
    {
        return m_propertyclass;
    }

    public OwFieldDefinition getFieldDefinition() throws OwException
    {
        return m_propertyclass;
    }

    public abstract void addTo(CmisPropertiesType cmisPropertiesType_p) throws OwException;

    public abstract Object getValue() throws OwException;

    public abstract void setValue(Object value_p) throws OwException;

    @SuppressWarnings("unchecked")
    public int compareTo(Object o_p)
    {
        return OwPropertyComparator.legacyCompare(this, o_p);
    }

    @Override
    public boolean equals(Object obj_p)
    {
        if (obj_p instanceof OwCMISProperty)
        {
            if (super.equals(obj_p))
            {//references are equals
                return true;
            }

            //compare if the names are equal
            OwCMISProperty cmisProperty = (OwCMISProperty) obj_p;
            OwCMISPropertyClass cmisPropertyClass = cmisProperty.getPropertyClass();
            return this.m_propertyclass.getClassName().equals(cmisPropertyClass.getClassName());
        }
        else
        {
            return false;
        }
    }

    @Override
    public int hashCode()
    {
        return this.m_propertyclass.getClassName().hashCode();
    }
}
