package com.wewebu.ow.server.ecmimpl.cmis.property;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISInternalPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISObjectName;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISObjectPath;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * Standard internal property implementation.<br/>
 * Models properties that only exist in Workdesk and are not defined in the Content Repository model. 
 * Theirs values can be hard-coded, computed from a combination of other properties etc.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 * @see OwCMISObjectPath#createProperty(OwCMISObject)
 * @see OwCMISObjectName#createProperty(OwCMISObject)
 */
public class OwCMISStandardInternalProperty extends OwCMISInternalProperty
{
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardInternalProperty.class);

    private Object value;

    public OwCMISStandardInternalProperty(OwCMISObject ownerObject_p, OwCMISInternalPropertyClass internalPropertyClass_p)
    {
        this(ownerObject_p, internalPropertyClass_p, null);
    }

    public OwCMISStandardInternalProperty(OwCMISObject ownerObject_p, OwCMISInternalPropertyClass internalPropertyClass_p, Object initialValue_p)
    {
        super(ownerObject_p, internalPropertyClass_p);
        this.value = initialValue_p;
    }

    @Override
    public void addTo(CmisPropertiesType cmisPropertiesType_p) throws OwException
    {
        LOG.error("standard internal properties can not be added to CMIS native collections!");
        throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardInternalProperty.non.cmis.value.error", "Standard internal properties can not be added to CMIS native collections!"));
    }

    @Override
    public Object getValue() throws OwException
    {
        return this.value;
    }

    @Override
    public void setValue(Object value_p) throws OwException
    {
        this.value = value_p;

    }

    public Object getNativeObject() throws Exception
    {
        return this.value;
    }

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder("cmis-property(internal-std,");
        builder.append(getPropertyClass().toString());
        builder.append("),");
        Object value = "<err-value>";
        try
        {
            value = getValue();
            if (value == null)
            {
                value = "<null-value>";
            }
        }
        catch (OwException e)
        {
            LOG.error("Could not retrieve value!", e);
        }
        builder.append("value=");
        builder.append(value.toString());
        builder.append(")");
        return builder.toString();
    }
}
