package com.wewebu.ow.server.ecmimpl.cmis.property;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBooleanDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTimeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimalDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyHtmlDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIdDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIntegerDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyStringDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyUriDefinitionType;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISIdObjectConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISDynamicQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassBoolean;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassDateTime;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassDecimal;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassHtml;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassId;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassInteger;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassString;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassUri;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISIDDMSIDConverter;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISSameTypeConverter;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISStandardDateConverter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;

/**
 *<p>
 * Standard implementation of the OwCMISPropertyFactory interface.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISStandardPropertyClassFactory implements OwCMISPropertyClassFactory
{
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardPropertyClassFactory.class);

    private static final List<String> NATIVE_ID_PROPERTIES = Arrays.asList(new String[] { OwCMISPropertyNames.OBJECT_ID.getId(), OwCMISPropertyNames.OBJECT_TYPE_ID.getId(), OwCMISPropertyNames.BASE_TYPE_ID.getId(),
            OwCMISPropertyNames.VERSION_SERIES_ID.getId(), OwCMISPropertyNames.PARENT_ID.getId(), OwCMISPropertyNames.CONTENT_STREAM_ID.getId(), OwCMISPropertyNames.ALLOWED_CHILD_OBJECTTYPE_IDS.getId(), "IndexationId" });
    private TimeZone clientTimeZone;
    private OwCMISNetworkConfiguration networkCfg;

    public OwCMISStandardPropertyClassFactory(TimeZone clientTimezone_p, OwCMISNetworkConfiguration networkConfiguration)
    {

        this.clientTimeZone = clientTimezone_p;
        this.networkCfg = networkConfiguration;
    }

    public OwCMISNativePropertyClass createPropertyClass(CmisPropertyDefinitionType propertyDefinition_p, OwCMISObjectClass cmisObjectClass_p) throws OwException
    {
        OwCMISNativePropertyClass propClass;
        try
        {
            OwCMISQuerySchema customQuerySchema = createQuerySchema(propertyDefinition_p);

            switch (propertyDefinition_p.getPropertyType())
            {
                case BOOLEAN:
                    propClass = new OwCMISPropertyClassBoolean((CmisPropertyBooleanDefinitionType) propertyDefinition_p, cmisObjectClass_p, getNetworkConfiguration(), customQuerySchema);
                    break;
                case DATETIME:
                    propClass = new OwCMISPropertyClassDateTime((CmisPropertyDateTimeDefinitionType) propertyDefinition_p, createDateConverter(), cmisObjectClass_p, getNetworkConfiguration());
                    break;
                case DECIMAL:
                    propClass = new OwCMISPropertyClassDecimal((CmisPropertyDecimalDefinitionType) propertyDefinition_p, cmisObjectClass_p, getNetworkConfiguration(), customQuerySchema);
                    break;
                case INTEGER:
                    propClass = new OwCMISPropertyClassInteger((CmisPropertyIntegerDefinitionType) propertyDefinition_p, cmisObjectClass_p, getNetworkConfiguration(), customQuerySchema);
                    break;
                case STRING:
                    propClass = new OwCMISPropertyClassString((CmisPropertyStringDefinitionType) propertyDefinition_p, cmisObjectClass_p, getNetworkConfiguration(), customQuerySchema);
                    break;
                case ID:
                    String propertyID = propertyDefinition_p.getId();
                    if (NATIVE_ID_PROPERTIES.contains(propertyID))
                    {
                        propClass = new OwCMISPropertyClassId<String>((CmisPropertyIdDefinitionType) propertyDefinition_p, new OwCMISSameTypeConverter<String>(String.class), cmisObjectClass_p, getNetworkConfiguration(), customQuerySchema);
                    }
                    else
                    {
                        OwCMISResource resource = cmisObjectClass_p.getResource();
                        OwCMISIDDMSIDConverter dmsidConverter = networkCfg.getIdDMSIDConverter(resource.getID());

                        OwCMISIdObjectConverterClass objectConverterClass = new OwCMISIdObjectConverterClass(dmsidConverter);
                        propClass = new OwCMISPropertyClassId<OwObject>((CmisPropertyIdDefinitionType) propertyDefinition_p, objectConverterClass, cmisObjectClass_p, getNetworkConfiguration(), customQuerySchema);
                    }
                    break;
                case HTML:
                    propClass = new OwCMISPropertyClassHtml((CmisPropertyHtmlDefinitionType) propertyDefinition_p, cmisObjectClass_p, getNetworkConfiguration(), customQuerySchema);
                    break;
                case URI:
                    propClass = new OwCMISPropertyClassUri((CmisPropertyUriDefinitionType) propertyDefinition_p, cmisObjectClass_p, getNetworkConfiguration(), customQuerySchema);
                    break;
                default:
                    LOG.fatal("OwCMISStandardPropertyClassFactory.createPropertyClass(): Unknown property type " + propertyDefinition_p.getPropertyType());
                    throw new OwInvalidOperationException("Unknown property type : " + propertyDefinition_p.getPropertyType());
            }
            return propClass;
        }
        catch (ClassCastException castEx)
        {
            String msg = "Type of property = " + cmisObjectClass_p.getQueryName() + " property " + propertyDefinition_p.getId() + " not matching instance! type = " + propertyDefinition_p.getPropertyType().value();
            LOG.fatal("OwCMISStandardPropertyClassFactory.createPropertyClass():" + msg, castEx);
            throw new OwServerException(msg + " but is: " + castEx.getMessage(), castEx);
        }
    }

    /**(overridable)<br />
     * Get an instance which is used for Date conversion.
     * @return OwCMISValueConverterClass
     * @since 3.2.0.0
     */
    protected OwCMISValueConverterClass<XMLGregorianCalendar, Date> createDateConverter()
    {
        return new OwCMISStandardDateConverter(getClientTimeZone());
    }

    /**
     * Get the Client TimeZone setting.
     * @return TimeZone which the client has.
     * @since 3.2.0.0
     */
    protected TimeZone getClientTimeZone()
    {
        return this.clientTimeZone;
    }

    /**
     * Getter for network configuration
     * @return OwCMISNetworkConfiguration
     * @since 4.0.0.1
     */
    protected OwCMISNetworkConfiguration getNetworkConfiguration()
    {
        return this.networkCfg;
    }

    /** (overridable)<br />
     * Factory method to create specific OwCMISQuerySchema depending on CmisPropertyDefinitionType.
     * <p>By default will create a OwCMISDynamicQuerySchema.</p>
     * @param typeDefinition_p CmisPropertyDefinitionType
     * @return OwCMISQuerySchema
     * @throws OwException
     * @since 3.2.0.3
     */
    protected OwCMISQuerySchema createQuerySchema(CmisPropertyDefinitionType typeDefinition_p) throws OwException
    {
        return new OwCMISDynamicQuerySchema(typeDefinition_p);
    }
}