package com.wewebu.ow.server.ecmimpl.cmis.property;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * OwCMISStandardPropertyCollectionConverter.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISStandardPropertyCollectionConverter implements OwCMISPropertyCollectionConverter
{

    private static final Logger LOG = OwLog.getLogger(OwCMISStandardPropertyCollectionConverter.class);
    private OwCMISConvertFilter filter;

    public OwCMISStandardPropertyCollectionConverter()
    {
        this(null);
    }

    public OwCMISStandardPropertyCollectionConverter(OwCMISConvertFilter filter_p)
    {
        super();
        this.filter = filter_p;
    }

    @SuppressWarnings("unchecked")
    public CmisPropertiesType createCmisProperties(OwPropertyCollection propertyCollection_p, OwCMISObject object_p, String resourceID_p, OwCMISNetwork network_p) throws OwException
    {
        try
        {
            ObjectFactory cmisObjectFactory = new ObjectFactory();

            CmisPropertiesType propertiesType = cmisObjectFactory.createCmisPropertiesType();

            if (propertyCollection_p != null && !propertyCollection_p.isEmpty())
            {
                Iterator it = propertyCollection_p.entrySet().iterator();
                while (it.hasNext())
                {
                    Map.Entry entry = (Entry) it.next();
                    OwProperty property = (OwProperty) entry.getValue();
                    if (filter == null || filter.accept(property))
                    {
                        if (!(property instanceof OwCMISProperty))
                        {
                            OwPropertyClass propertyClass = property.getPropertyClass();
                            if (!(propertyClass instanceof OwCMISNativePropertyClass))
                            {
                                propertyClass = network_p.getPropertyClass(propertyClass.getClassName(), resourceID_p);
                            }

                            OwCMISPropertyClass cmisPropertyClass = (OwCMISPropertyClass) propertyClass;
                            property = cmisPropertyClass.newProperty(object_p, property.getValue(), network_p);
                        }

                        if (property instanceof OwCMISProperty)
                        {
                            OwCMISProperty cmisProperty = (OwCMISProperty) property;
                            cmisProperty.addTo(propertiesType);
                        }
                        else
                        {
                            OwPropertyClass propertyClass = property.getPropertyClass();
                            if (propertyClass instanceof OwCMISPropertyClass)
                            {
                                OwCMISPropertyClass cmisPropertyClass = (OwCMISPropertyClass) propertyClass;
                                OwCMISProperty cmisProperty = cmisPropertyClass.newProperty(null, property.getValue(), network_p);
                                cmisProperty.addTo(propertiesType);
                            }
                            else
                            {
                                String propertyClassName = "<null class>";
                                if (propertyClass != null)
                                {
                                    propertyClassName = propertyClass.getClassName();
                                }
                                LOG.debug("OwCMISStandardPropertyCollectionConverter.createCmisProperties(): skipped non CMIS property " + propertyClassName);
                            }
                        }
                    }
                }
            }
            return propertiesType;
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.fatal("OwCMISStandardPropertyCollectionConverter.createCmisProperties(): Invalid property collection!", e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardPropertyCollectionConverter.invalid.property.collection.error", "Invalid property collection!"), e);
        }
    }

}
