package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;

/**
 *<p>
 * Query schema which handles dynamically the context specific querying.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISDynamicQuerySchema implements OwCMISQuerySchema
{
    private CmisPropertyDefinitionType propertyDefinitionType;

    public OwCMISDynamicQuerySchema(CmisPropertyDefinitionType propertyDefinitionType_p)
    {
        this.propertyDefinitionType = propertyDefinitionType_p;
    }

    public String getQueryName(OwCMISQueryContext context_p)
    {
        String qName = null;
        if (isQueryable(context_p))
        {
            qName = this.propertyDefinitionType.getQueryName();
        }
        if (qName == null)
        {
            qName = this.propertyDefinitionType.getId();
        }

        return qName;
    }

    public boolean isQueryable(OwCMISQueryContext context_p)
    {
        if (this.propertyDefinitionType.isQueryable())
        {//independent from context can be retrieved every time
            return Boolean.TRUE.booleanValue();
        }
        else
        {
            return context_p == OwCMISQueryContext.GET_PROPERTY;
        }
    }
}
