package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisChoice;

import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISChoiceBinding;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwStandardEnum;
import com.wewebu.ow.server.field.OwStandardEnumCollection;

/**
 *<p>
 * OwCMISEnumTemplate.
 * Helper class to convert the native choice representation into
 * an OwEnumCollection.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISEnumTemplate
{
    public <L, O, C extends CmisChoice> OwEnumCollection createEnumCollection(List<OwCMISChoiceBinding<L>> choiceBindings_p, OwCMISValueConverterClass<L, O> converterClass_p, boolean isArray_p) throws OwInvalidOperationException
    {
        OwStandardEnumCollection enumCollection = new OwStandardEnumCollection();
        for (OwCMISChoiceBinding<L> choiceBinding : choiceBindings_p)
        {
            CmisChoice nativeChoice = choiceBinding.getChoice();
            List<OwCMISChoiceBinding<L>> subChoices = choiceBinding.getSubChoices();

            OwEnumCollection subEnumCollection = createEnumCollection(subChoices, converterClass_p, isArray_p);
            if (!subEnumCollection.isEmpty())
            {
                OwCMISSubCollectionEnum cmisSubEnum = new OwCMISSubCollectionEnum(nativeChoice.getDisplayName(), subEnumCollection);
                enumCollection.add(cmisSubEnum);
            }
            else
            {
                List<L> choiceValues = choiceBinding.getValues();
                Object value = converterClass_p.toStaticValue(choiceValues);
                if (value != null)
                {
                    OwStandardEnum stdEnum = new OwStandardEnum(value, nativeChoice.getDisplayName());
                    enumCollection.add(stdEnum);
                }
            }
        }

        return enumCollection;
    }
}
