package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.util.Collection;
import java.util.List;
import java.util.Locale;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwFormat;

/**
 *<p>
 * OwCMISInternalPropertyClass.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
@SuppressWarnings("unchecked")
public abstract class OwCMISInternalPropertyClass implements OwCMISPropertyClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISInternalPropertyClass.class);

    private OwPropertyClass delegateClass;
    private OwCMISObjectClass objectClass;

    public OwCMISInternalPropertyClass(OwPropertyClass delegatePropertyClass_p, OwCMISObjectClass objectClass_p)
    {
        this.delegateClass = delegatePropertyClass_p;
        this.objectClass = objectClass_p;
    }

    public OwCMISProperty newProperty(OwCMISObject object_p, Object value_p, OwCMISNetwork network_p) throws OwException
    {
        OwCMISInternalProperty internalProperty = createProperty(object_p);
        internalProperty.setValue(value_p);
        return internalProperty;
    }

    public abstract OwCMISInternalProperty createProperty(OwCMISObject object_p) throws OwException;

    public final OwCMISObjectClass getObjectClass()
    {
        return this.objectClass;
    }

    public String getCategory() throws Exception
    {
        return this.delegateClass.getCategory();
    }

    public String getClassName()
    {
        return this.delegateClass.getClassName();
    }

    public List getComplexChildClasses() throws Exception
    {
        return this.delegateClass.getComplexChildClasses();
    }

    public Object getDefaultValue() throws Exception
    {
        return this.delegateClass.getDefaultValue();
    }

    public String getDescription(Locale locale_p)
    {
        return this.delegateClass.getDescription(locale_p);
    }

    public String getDisplayName(Locale locale_p)
    {
        return this.delegateClass.getDisplayName(locale_p);
    }

    public OwEnumCollection getEnums() throws Exception
    {
        return this.delegateClass.getEnums();
    }

    public OwFormat getFormat()
    {
        return this.delegateClass.getFormat();
    }

    public String getJavaClassName()
    {
        return this.delegateClass.getJavaClassName();
    }

    public Object getMaxValue() throws Exception
    {
        return this.delegateClass.getMaxValue();
    }

    public Object getMinValue() throws Exception
    {
        return this.delegateClass.getMinValue();
    }

    public Object getNativeType() throws Exception
    {
        return this.delegateClass.getNativeType();
    }

    public Node getNodeFromValue(Object value_p, Document doc_p) throws Exception
    {
        return this.delegateClass.getNodeFromValue(value_p, doc_p);
    }

    @SuppressWarnings("rawtypes")
    public Collection getOperators() throws Exception
    {
        return this.delegateClass.getOperators();
    }

    public Object getValueFromNode(Node node_p) throws Exception
    {
        return this.delegateClass.getValueFromNode(node_p);
    }

    public Object getValueFromString(String text_p) throws Exception
    {
        return this.delegateClass.getValueFromString(text_p);
    }

    public boolean isArray() throws Exception
    {
        return this.delegateClass.isArray();
    }

    public boolean isComplex()
    {
        return this.delegateClass.isComplex();
    }

    public boolean isEnum() throws Exception
    {
        return this.delegateClass.isEnum();
    }

    public boolean isHidden(int context_p) throws Exception
    {
        return this.delegateClass.isHidden(context_p);
    }

    public boolean isNameProperty() throws Exception
    {
        return this.delegateClass.isNameProperty();
    }

    public boolean isReadOnly(int context_p) throws Exception
    {
        return this.delegateClass.isReadOnly(context_p);
    }

    public boolean isRequired() throws Exception
    {
        return this.delegateClass.isRequired();
    }

    public boolean isSystemProperty() throws Exception
    {
        return this.delegateClass.isSystemProperty();
    }

    public String getFullQualifiedName()
    {
        return getClassName();
    }

    public String getNonQualifiedName()
    {
        return getClassName();
    }

    @Override
    public int hashCode()
    {
        return getClassName().hashCode();
    }

    @Override
    public boolean equals(Object obj_p)
    {
        if (obj_p instanceof OwCMISInternalPropertyClass)
        {
            OwCMISInternalPropertyClass nativeClassObject = (OwCMISInternalPropertyClass) obj_p;
            return nativeClassObject.getClassName().equals(this.getClassName());
        }
        else
        {
            return false;
        }
    }

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder("class(native,");
        builder.append(getClassName());
        builder.append(",");
        builder.append(getClass().getSimpleName());
        String hiddenString = "<err-hidden-status>";

        try
        {
            hiddenString = isHidden(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS) ? "hidden" : "visible";
        }
        catch (Exception e)
        {
            LOG.error("Could not retrieve the hidden status of the class !", e);
        }
        builder.append(",");
        builder.append(hiddenString);
        builder.append(",queryable=");
        builder.append(isQueryable(OwCMISQueryContext.SQL));
        builder.append(")");
        return builder.toString();
    }
}
