package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.util.Collection;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISMappedInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISMappedInternalPropertyClass.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISMappedInternalPropertyClass extends OwCMISInternalPropertyClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISMappedInternalPropertyClass.class);

    private OwCMISPropertyClass mappedPropertyClass;

    public OwCMISMappedInternalPropertyClass(OwPropertyClass delegatePropertyClass_p, OwCMISObjectClass objectClass_p, OwCMISPropertyClass mappedPropertyClass_p)
    {
        super(delegatePropertyClass_p, objectClass_p);
        this.mappedPropertyClass = mappedPropertyClass_p;
    }

    @Override
    public OwCMISInternalProperty createProperty(OwCMISObject object_p) throws OwException
    {
        OwCMISProperty mappedProperty = object_p.getProperty(this.mappedPropertyClass.getClassName());
        return new OwCMISMappedInternalProperty(object_p, this, mappedProperty);
    }

    public OwCMISPropertyClass getMappedNativePropertyClass()
    {
        return this.mappedPropertyClass;
    }

    public boolean isQueryable(OwCMISQueryContext context_p)
    {
        return this.mappedPropertyClass.isQueryable(context_p);
    }

    public String getQueryName(OwCMISQueryContext context_p)
    {
        return this.mappedPropertyClass.getQueryName(context_p);
    }

    public boolean isOrderable()
    {
        return this.mappedPropertyClass.isOrderable();
    }

    @SuppressWarnings("unchecked")
    @Override
    public Collection getOperators() throws Exception
    {
        return this.mappedPropertyClass.getOperators();
    }

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder("class(native,");
        builder.append(getClassName());
        builder.append(",");
        builder.append(getClass().getSimpleName());
        builder.append(",");
        String hiddenString = "<err-hidden-status>";

        try
        {
            hiddenString = isHidden(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS) ? "hidden" : "visible";
        }
        catch (Exception e)
        {
            LOG.error("Could not retrieve the hidden status of the class !", e);
        }
        builder.append(hiddenString);
        builder.append(",->");
        builder.append(mappedPropertyClass.toString());
        builder.append(")");
        return builder.toString();
    }

}
