package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumUpdatability;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString2;

/**
 *<p>
 * Property class wrapper for CMIS property definition type.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public abstract class OwCMISNativePropertyClass implements OwCMISPropertyClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISNativePropertyClass.class);

    private OwEnumCollection m_enums;
    private OwCMISObjectClass m_objectClass;

    private OwCMISQuerySchema propertyQuerySchema;

    public OwCMISNativePropertyClass(OwCMISObjectClass objectClass_p, OwCMISQuerySchema querySchema_p)
    {
        m_objectClass = objectClass_p;
        this.propertyQuerySchema = querySchema_p;
    }

    public OwCMISNativeProperty newProperty(OwCMISObject object_p, Object value_p, OwCMISNetwork netowrk_p) throws OwException
    {
        OwCMISNativeProperty property = createProperty(null, netowrk_p);
        property.setValue(value_p);
        return property;
    }

    public abstract OwCMISNativeProperty createProperty(CmisProperty property_p, OwCMISNetwork network_p) throws OwInvalidOperationException;

    protected abstract OwEnumCollection createEnums() throws OwException;

    public String getCategory() throws OwException
    {
        return "";
    }

    public boolean isHidden(int context_p) throws OwException
    {
        return Boolean.FALSE.booleanValue();
    }

    //TODO move this to an externel configuration. Ex. owbootstrap.xml
    private static final List<String> NAME_PROPERTY_IDS = new ArrayList<String>();
    static
    {
        NAME_PROPERTY_IDS.add(OwCMISPropertyNames.NAME.getId());
        NAME_PROPERTY_IDS.add("bpm:description");
    }

    public boolean isNameProperty() throws OwException
    {
        //        return OwCMISPropertyNames.NAME.isSameId(getNativeType());
        return NAME_PROPERTY_IDS.contains(getNativeType().getId());
    }

    public boolean isReadOnly(int context_p) throws OwException
    {
        boolean readonly = false;
        if (getNativeType().getUpdatability() != null)
        {
            switch (getNativeType().getUpdatability())
            {
                case READONLY:
                    readonly = true;
                    break;
                case READWRITE:
                    break;
                case WHENCHECKEDOUT:
                    readonly = context_p != OwPropertyClass.CONTEXT_ON_CHECKIN;
                    break;
                case ONCREATE:// ONCREATE available since CMIS v0.63
                    readonly = context_p != OwPropertyClass.CONTEXT_ON_CREATE;
                    break;
                default:
                    /*should be false*/
                    ;
            }
        }
        else
        {
            LOG.debug("OwCMISNativeProperty.isReadOnly: getNativeType().getUpdatability() == null for " + getNonQualifiedName() + " returning default true");
            readonly = true;
        }
        return readonly;
    }

    public boolean isSystemProperty() throws OwException
    {
        if (getNativeType().getUpdatability() == EnumUpdatability.READONLY)
        {
            return Boolean.TRUE.booleanValue();
        }
        else
        {
            return OwCMISPropertyNames.OBJECT_TYPE_ID.getId().equals(getNonQualifiedName()) || OwCMISPropertyNames.CONTENT_STREAM_FILENAME.getId().equals(getNonQualifiedName());
        }
    }

    public String getNonQualifiedName()
    {
        return getNativeType().getId();
    }

    public String getClassName()
    {
        return getFullQualifiedName();
    }

    public List<?> getComplexChildClasses() throws OwException
    {
        // TODO Auto-generated method stub
        return null;
    }

    public Object getDefaultValue() throws OwException
    {
        return null;//TODO request if it has a default value
    }

    public String getDescription(Locale locale_p)
    {
        return OwString.localize(locale_p, OwString.LABEL_PREFIX + getClassName() + ".Desc", getNativeType().getDescription());
    }

    public String getDisplayName(Locale locale_p)
    {
        return OwString.localize(locale_p, OwString.LABEL_PREFIX + getClassName(), getNativeType().getDisplayName());
    }

    public OwEnumCollection getEnums() throws OwException
    {
        if (m_enums == null)
        {
            m_enums = createEnums();
        }

        return m_enums;
    }

    public abstract OwCMISNativeFormat getFormat();

    public abstract CmisPropertyDefinitionType getNativeType();

    public Node getNodeFromValue(Object value_p, Document doc_p) throws OwException
    {
        return value_p != null ? doc_p.createTextNode(value_p.toString()) : null;
    }

    public Object getValueFromNode(Node node_p) throws OwException
    {
        if (null == node_p)
        {
            // === a empty node
            return null;
        }
        else if (node_p.getNodeType() == Node.TEXT_NODE)
        {
            // === a text node
            return getValueFromString(node_p.getNodeValue());
        }
        else
        {
            LOG.fatal("OwCMISNativePropertyClass.getValueFromNode(): Unsupported node type : " + node_p.getNodeType());
            throw new OwNotSupportedException(new OwString("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
        }
    }

    public Object getValueFromString(String text_p) throws OwException
    {
        OwCMISNativeFormat format = getFormat();

        if (format == null)
        {
            String msg = "No OwFormat found for property class " + getClassName() + " @ java implementation " + getClass().getName();
            LOG.error("OwCMISNativePropertyClass.getValueFromString():" + msg);
            throw new OwInvalidOperationException(new OwString2("ecmimpl.cmis.OwCMISNativePropertyClass.noformat.error", "No OwFormat found for property class %1  @ java implementation %2", getClassName(), getClass().getName()));
        }

        return format.parse(text_p, isArray());
    }

    public boolean isArray() throws OwException
    {
        switch (getNativeType().getCardinality())
        {
            case MULTI:
                return true;

            default:
                return false;
        }
    }

    public boolean isComplex()
    {
        return Boolean.FALSE.booleanValue();
    }

    public boolean isEnum() throws OwException
    {
        return getEnums() != null && !getEnums().isEmpty();
    }

    public boolean isRequired() throws OwException
    {
        return getNativeType().isRequired();
    }

    public String getQueryName(OwCMISQueryContext context_p)
    {
        return this.propertyQuerySchema.getQueryName(context_p);
    }

    public String getFullQualifiedName()
    {
        OwCMISObjectClass objectClass = getObjectClass();
        String objectClassName = objectClass.getClassName();
        return objectClassName + "." + getNonQualifiedName();
    }

    public OwCMISObjectClass getObjectClass()
    {
        return this.m_objectClass;
    }

    public boolean isQueryable(OwCMISQueryContext context_p)
    {
        return this.propertyQuerySchema.isQueryable(context_p);
    }

    public boolean isOrderable()
    {
        return getNativeType().isOrderable();
    }

    @Override
    public int hashCode()
    {
        return getClassName().hashCode();
    }

    @Override
    public boolean equals(Object obj_p)
    {
        if (obj_p instanceof OwCMISNativePropertyClass)
        {
            OwCMISNativePropertyClass nativeClassObject = (OwCMISNativePropertyClass) obj_p;
            return nativeClassObject.getClassName().equals(this.getClassName());
        }
        else
        {
            return false;
        }
    }

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder("class(native,");
        builder.append(getClassName());
        builder.append(",");
        builder.append(getClass().getSimpleName());
        String hiddenString = "<err-hidden-status>";

        try
        {
            hiddenString = isHidden(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS) ? "hidden" : "visible";
        }
        catch (Exception e)
        {
            LOG.error("Could not retrieve the hidden status of the class !", e);
        }
        builder.append(",");
        builder.append(hiddenString);
        builder.append(",queryable=");
        builder.append(isQueryable(OwCMISQueryContext.SQL));
        builder.append(")");
        return builder.toString();
    }
}