package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISPreferredPropertyTypeCfg;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISPreferredPropertyTypeCfg.PropertyType;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISChoiceBinding;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISNativePropertyBinding;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISPropertyDefinition;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativePropertyTemplate;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwEnumCollection;

/**
 *<p>
 * OwCMISNativePropertyClassTemplate.
 * Basis class with default implementation for internal
 * OwPropertyClass.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public abstract class OwCMISNativePropertyClassTemplate<L, O> extends OwCMISNativePropertyClass
{
    private static final Logger LOG = OwLog.getLogger(OwCMISNativePropertyClassTemplate.class);

    private OwCMISPropertyDefinition<L> propertyDefinition;
    private OwCMISValueConverterClass<L, O> converterClass;
    private OwCMISNetworkConfiguration networkCfg;
    private PropertyType prefferedType;

    public OwCMISNativePropertyClassTemplate(OwCMISPropertyDefinition<L> propertyDefinition_p, OwCMISValueConverterClass<L, O> converterClass_p, OwCMISObjectClass objectClass_p, OwCMISQuerySchema querySchema_p)
    {
        super(objectClass_p, querySchema_p);
        this.propertyDefinition = propertyDefinition_p;
        this.converterClass = converterClass_p;
    }

    public OwCMISNativePropertyClassTemplate(OwCMISPropertyDefinition<L> propertyDefinition_p, OwCMISValueConverterClass<L, O> converterClass_p, OwCMISObjectClass objectClass_p, OwCMISNetworkConfiguration networkCfg, OwCMISQuerySchema querySchema_p)
    {
        super(objectClass_p, querySchema_p);
        this.propertyDefinition = propertyDefinition_p;
        this.converterClass = converterClass_p;

        this.networkCfg = networkCfg;
    }

    private PropertyType getPreferredType()
    {
        //this.getNonQualifiedName(), getObjectClass()
        PropertyType preferredType = null;
        if (null != this.networkCfg)
        {
            OwCMISPreferredPropertyTypeCfg preferredPropCfg = this.networkCfg.getPreferredPropertyTypeCfg();
            try
            {
                preferredType = preferredPropCfg.getPreferredType(this);
            }
            catch (OwException e)
            {
                LOG.error("Could not process preferred type configuration.", e);
            }
        }
        if (null == preferredType)
        {
            preferredType = PropertyType.UNSET;
        }
        return preferredType;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass#isSystemProperty()
     */
    @Override
    public boolean isSystemProperty() throws OwException
    {
        if (null == this.prefferedType)
        {
            this.prefferedType = getPreferredType();
        }

        if (PropertyType.UNSET == this.prefferedType)
        {
            return super.isSystemProperty();
        }

        return PropertyType.SYSTEM == this.prefferedType;
    }

    @Override
    protected OwEnumCollection createEnums() throws OwException
    {
        OwCMISEnumTemplate booleanEnumTemplate = new OwCMISEnumTemplate();
        List<OwCMISChoiceBinding<L>> choices = this.propertyDefinition.getChoice();
        OwEnumCollection enumCollection = booleanEnumTemplate.createEnumCollection(choices, this.converterClass, isArray());
        return enumCollection;
    }

    @Override
    public OwCMISNativeProperty createProperty(CmisProperty property_p, OwCMISNetwork network_p) throws OwInvalidOperationException
    {
        OwCMISNativePropertyBinding<L> propertyBinding = this.propertyDefinition.createBoundProperty(property_p);
        OwCMISValueConverter<L, O> converter = this.converterClass.newConverter(network_p);
        OwCMISNativePropertyTemplate<L, O> templateProperty = new OwCMISNativePropertyTemplate<L, O>(propertyBinding, converter, this);
        return templateProperty;
    }

    public String getJavaClassName()
    {
        return this.converterClass.getOClass().getName();
    }

    @Override
    public CmisPropertyDefinitionType getNativeType()
    {
        return this.propertyDefinition.getNativeDefinition();
    }

    public Object getMaxValue() throws OwInvalidOperationException
    {
        L maxValue = this.propertyDefinition.getMaxValue();
        List<L> cmisVList = new LinkedList<L>();
        if (maxValue != null)
        {
            cmisVList.add(maxValue);
        }
        return converterClass.toStaticValue(cmisVList);

    }

    public Object getMinValue() throws OwInvalidOperationException
    {
        L minValue = this.propertyDefinition.getMinValue();
        List<L> cmisVList = new LinkedList<L>();
        if (minValue != null)
        {
            cmisVList.add(minValue);
        }
        return converterClass.toStaticValue(cmisVList);
    }

    /**
     * Return the current value converter of property class.
     * @return OwCMISValueConverterClass
     * @since 4.0.0.0
     */
    protected OwCMISValueConverterClass<L, O> getConverterClass()
    {
        return this.converterClass;
    }
}
