package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardInternalProperty;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Resource object name property (OW_ClassDescription) implementation for CMIS.<br/>
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.2
 */
public class OwCMISObjectClassDescription extends OwCMISInternalPropertyClass
{
    public OwCMISObjectClassDescription(OwCMISObjectClass objectClass_p)
    {
        super(OwResource.m_ClassDescriptionPropertyClass, objectClass_p);
    }

    @Override
    public OwCMISInternalProperty createProperty(OwCMISObject object_p) throws OwException
    {
        OwCMISObjectClass objectClass = object_p.getObjectClass();
        return new OwCMISStandardInternalProperty(object_p, this, objectClass.getNativeObject().getDisplayName());
    }

    public String getQueryName(OwCMISQueryContext context_p)
    {
        return OwResource.m_ClassDescriptionPropertyClass.getClassName();
    }

    public boolean isOrderable()
    {
        return true;
    }

    public boolean isQueryable(OwCMISQueryContext context_p)
    {
        return false;
    }
}
