package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.util.Collection;
import java.util.LinkedList;

import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardInternalProperty;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwSearchOperator;

/**
 *<p>
 * Resource object name property (OW_ObjectName) implementation for CMIS.<br/>
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISObjectName extends OwCMISInternalPropertyClass
{
    public static final Collection<Integer> DEFAULT_OPERATORS = new LinkedList<Integer>();
    static
    {
        DEFAULT_OPERATORS.add(Integer.valueOf(OwSearchOperator.CRIT_OP_LIKE));
        DEFAULT_OPERATORS.add(Integer.valueOf(OwSearchOperator.CRIT_OP_NOT_LIKE));
        DEFAULT_OPERATORS.add(Integer.valueOf(OwSearchOperator.CRIT_OP_EQUAL));
        DEFAULT_OPERATORS.add(Integer.valueOf(OwSearchOperator.CRIT_OP_NOT_EQUAL));
    }

    public OwCMISObjectName(OwCMISObjectClass objectClass_p)
    {
        super(OwResource.m_ObjectNamePropertyClass, objectClass_p);
    }

    @Override
    public OwCMISInternalProperty createProperty(OwCMISObject object_p) throws OwException
    {
        OwCMISObjectClass objectClass = object_p.getObjectClass();
        String namePropertyName = objectClass.getNamePropertyName();
        OwCMISProperty nameProperty = object_p.getProperty(namePropertyName);

        return new OwCMISStandardInternalProperty(object_p, this, nameProperty.getValue());
    }

    public String getQueryName(OwCMISQueryContext context_p)
    {
        return "cmis:name";
    }

    public boolean isOrderable()
    {
        try
        {
            OwCMISPropertyClass prop = getObjectClass().getPropertyClass(getObjectClass().getNamePropertyName());
            return prop == this ? true : prop.isOrderable();
        }
        catch (OwException e)
        {
            return false;
        }
    }

    public boolean isQueryable(OwCMISQueryContext context_p)
    {
        try
        {
            OwCMISPropertyClass prop = getObjectClass().getPropertyClass(getObjectClass().getNamePropertyName());
            return prop == this ? true : prop.isQueryable(context_p);
        }
        catch (OwException e)
        {
            return false;
        }
    }

    @SuppressWarnings("rawtypes")
    public Collection getOperators() throws Exception
    {
        return DEFAULT_OPERATORS;
    }

}
