package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardInternalProperty;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;

/**
 *<p>
 * Resource object name property (OW_ObjectPath) implementation for CMIS.<br/>
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.4
 */
public class OwCMISObjectPath extends OwCMISInternalPropertyClass
{

    public OwCMISObjectPath(OwCMISObjectClass objectClass_p)
    {
        super(OwResource.m_ObjectPathPropertyClass, objectClass_p);
        // TODO Auto-generated constructor stub
    }

    public String getQueryName(OwCMISQueryContext context_p)
    {
        return OwResource.m_ObjectPathPropertyClass.getClassName();
    }

    public boolean isQueryable(OwCMISQueryContext context_p)
    {
        return false;
    }

    public boolean isOrderable()
    {
        return false;
    }

    @Override
    public OwCMISInternalProperty createProperty(OwCMISObject object_p) throws OwException
    {
        OwCMISStandardInternalProperty prop = new OwCMISStandardInternalProperty(object_p, this);
        try
        {
            String path = object_p.getPath();
            prop.setValue(path);
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            throw new OwServerException("Could not retrieve path information from object", e);
        }
        return prop;
    }

}