package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISPropertyClass.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISPropertyClass extends OwPropertyClass
{
    /**
     * Get the ObjectClassName which is
     * parent of this property.
     * @return String id/name of object class
     */
    OwCMISObjectClass getObjectClass();

    /**
     * Returns the full qualified name
     * which is created from the {@link #getObjectClass()} class name
     * and the {@link #getNonQualifiedName()}, separated with an
     * '.' (dot) between the names.
     * @return String representing the full qualified name
     */
    String getFullQualifiedName();

    /**
     * Returns the non qualified name ( the CMIS definition
     * name of this property)
     * 
     * @return String representing the full qualified name
     */
    String getNonQualifiedName();

    /**
     * Returns the specified queryName of the
     * property which should be used in search request
     * instead of the id or property name.
     * <p>see CMIS spec 1.0, chapter 2.1.3.2.1 Attributes common to ALL Object-Type Property Definitions</p>
     * @return String queryName
     */
    String getQueryName(OwCMISQueryContext context_p);

    /**
     * Returns a boolean representation if this property can occur in WHERE clause for filtration.
     * <p>see CMIS spec 1.0, chapter 2.1.3.2.1 Attributes common to ALL Object-Type Property Definitions</p>
     * @return boolean <b>true</b> if possible to use for filtering, else <b>false</b>
     */
    boolean isQueryable(OwCMISQueryContext context_p);

    /**
     * Returns a boolean representation, notifying the possibility of this property to be used in ORDER BY clause.
     * <p>see CMIS specification 1.0, chapter 2.1.3.2.1 Attributes common to ALL Object-Type Property Definitions</p>
     * @return boolean <b>true</b> if possible to order/sort the values, else <b>false</b>.
     */
    boolean isOrderable();

    /**
     * Create a new Instance of the specific OwCMISProperty depending on the 
     * current OwCMISPropertyClass.
     * @param object_p OwCMISObject to be used, can be null
     * @param value_p Object the initial value which should be set, can be null
     * @param network_p current network
     * @return OwCMISProperty with given value, depending on the current property class.
     * @throws OwException if creation of OwCMISProperty failed
     */
    OwCMISProperty newProperty(OwCMISObject object_p, Object value_p, OwCMISNetwork network_p) throws OwException;
}
