package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTimeDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISPropertyDateTimeDefinition;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwSearchOperator;

/**
 *<p>
 * Property class wrapper for CMIS property definition type DateTime.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyClassDateTime extends OwCMISNativePropertyClassTemplate<XMLGregorianCalendar, Date>
{
    //private static final Logger LOG = OwLog.getLogger(OwCMISPropertyClassDateTime.class);

    protected Collection<Integer> operators;

    public OwCMISPropertyClassDateTime(CmisPropertyDateTimeDefinitionType propertyDefinition_p, OwCMISValueConverterClass<XMLGregorianCalendar, Date> valueConverter_p, OwCMISObjectClass objectClass_p, OwCMISNetworkConfiguration networkCfg)
    {
        this(propertyDefinition_p, valueConverter_p, objectClass_p, networkCfg, new OwCMISDynamicQuerySchema(propertyDefinition_p));
    }

    /**
     * Create a date based property class object.
     * @param propertyDefinition_p CmisPropertyDateTimeDefinitionType native definition
     * @param valueConverter_p OwCMISValueConverterClass<XMLGregorianCalendar, Date> converter with specific time zone
     * @param objectClass_p OwCMISObjectClass it belongs to
     * @param networkCfg OwCMISNetworkConfiguration (can be null)
     * @param querySchema_p OwCMISQuerySchema controlling how property can be retrieved
     */
    public OwCMISPropertyClassDateTime(CmisPropertyDateTimeDefinitionType propertyDefinition_p, OwCMISValueConverterClass<XMLGregorianCalendar, Date> valueConverter_p, OwCMISObjectClass objectClass_p, OwCMISNetworkConfiguration networkCfg,
            OwCMISQuerySchema querySchema_p)
    {
        super(new OwCMISPropertyDateTimeDefinition(propertyDefinition_p), valueConverter_p, objectClass_p, networkCfg, querySchema_p);
    }

    public synchronized Collection<Integer> getOperators() throws Exception
    {
        if (this.operators == null)
        {
            this.operators = new LinkedList<Integer>();

            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_NOT_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_LESS));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_LESS_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_GREATER));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_GREATER_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_IS_IN));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_IS_NOT_IN));
        }

        return operators;
    }

    @Override
    public OwCMISNativeFormat getFormat()
    {
        SimpleDateFormat zoneDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        SimpleDateFormat noZoneDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        OwISOSimpleFormatAdapter adapter = new OwISOSimpleFormatAdapter(zoneDateFormat, noZoneDateFormat);
        return new OwCMISNativeFormat(adapter, Date.class);
    }

    @Override
    public Object getDefaultValue() throws OwException
    {
        CmisPropertyDateTimeDefinitionType nativeDef = (CmisPropertyDateTimeDefinitionType) getNativeType();
        if (nativeDef.getDefaultValue() != null)
        {
            List<XMLGregorianCalendar> defValue = nativeDef.getDefaultValue().getValue();
            if (isArray())
            {
                return getConverterClass().toStaticArrayValue(defValue);
            }
            else
            {
                return getConverterClass().toStaticValue(defValue);
            }
        }
        else
        {
            return super.getDefaultValue();
        }
    }
}