package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Interface defining the methods for the Factory.<br/><br/>
 * ATTENTION: The implementing class should have at least a 
 * constructor <code>&lt;OwCMISPropertyFactory&gt;(OwCMISNetwork network)</code>
 * which will be used to create instances of the factory.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISPropertyClassFactory
{

    /**
     * Creates a OwCMISPropertyClassBase object depending on the given
     * information defined by the parameters.
     * @param propDef_p CmisPropertyDefinitionType the native CMIS property definition object 
     * @param cmisObjectClass_p the object class that defines the property
     * @return OwCMISProeprtyClassBase object
     * @throws OwException if creation of OwCMISPropertyClassBase cause a problem
     */
    OwCMISPropertyClass createPropertyClass(CmisPropertyDefinitionType propDef_p, OwCMISObjectClass cmisObjectClass_p) throws OwException;

}