package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyHtmlDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISPropertyHtmlDefinition;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISSameTypeConverter;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISStringTransparentTextFormat;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwSearchOperator;

/**
 *<p>
 * Property class wrapper for CMIS property definition type HTML.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyClassHtml extends OwCMISNativePropertyClassTemplate<String, String>
{
    //private static final Logger LOG = OwLog.getLogger(OwCMISPropertyClassHtml.class);

    protected Collection<Integer> operators;

    public OwCMISPropertyClassHtml(CmisPropertyHtmlDefinitionType propertyDefinition_p, OwCMISObjectClass objectClass_p)
    {
        this(propertyDefinition_p, new OwCMISSameTypeConverter<String>(String.class), objectClass_p, new OwCMISDynamicQuerySchema(propertyDefinition_p));
    }

    /**
     * Simple constructor for specific OwCMISQuerySchema
     * @param propertyDef
     * @param objClass
     * @param querySchema
     * @since 4.0.0.1
     */
    public OwCMISPropertyClassHtml(CmisPropertyHtmlDefinitionType propertyDef, OwCMISObjectClass objClass, OwCMISQuerySchema querySchema)
    {
        this(propertyDef, new OwCMISSameTypeConverter<String>(String.class), objClass, querySchema);
    }

    /**
     * Simple constructor for OwCMISQuerySchema and OwCMISNetworkConfiguration
     * @param propertyDef
     * @param objClass
     * @param networkCfg
     * @param querySchema
     * @since 4.0.0.1
     */
    public OwCMISPropertyClassHtml(CmisPropertyHtmlDefinitionType propertyDef, OwCMISObjectClass objClass, OwCMISNetworkConfiguration networkCfg, OwCMISQuerySchema querySchema)
    {
        this(propertyDef, new OwCMISSameTypeConverter<String>(String.class), objClass, networkCfg, querySchema);
    }

    public OwCMISPropertyClassHtml(CmisPropertyHtmlDefinitionType propertyDefinition_p, OwCMISValueConverterClass<String, String> valueConverter_p, OwCMISObjectClass objectClass_p)
    {
        this(propertyDefinition_p, valueConverter_p, objectClass_p, new OwCMISDynamicQuerySchema(propertyDefinition_p));
    }

    public OwCMISPropertyClassHtml(CmisPropertyHtmlDefinitionType propertyDefinition_p, OwCMISValueConverterClass<String, String> valueConverter_p, OwCMISObjectClass objectClass_p, OwCMISQuerySchema querySchema_p)
    {
        super(new OwCMISPropertyHtmlDefinition(propertyDefinition_p), valueConverter_p, objectClass_p, querySchema_p);
    }

    /**
     * Constructor for OwCMISNetworkConfiguration
     * @param propertyDef
     * @param valueConverter
     * @param objClass
     * @param networkCfg
     * @param querySchema_p
     * @since 4.0.0.1
     */
    public OwCMISPropertyClassHtml(CmisPropertyHtmlDefinitionType propertyDef, OwCMISValueConverterClass<String, String> valueConverter, OwCMISObjectClass objClass, OwCMISNetworkConfiguration networkCfg, OwCMISQuerySchema querySchema_p)
    {
        super(new OwCMISPropertyHtmlDefinition(propertyDef), valueConverter, objClass, networkCfg, querySchema_p);
    }

    public synchronized Collection<Integer> getOperators() throws Exception
    {
        if (this.operators == null)
        {

            this.operators = new LinkedList<Integer>();
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_NOT_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_IS_IN));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_IS_NOT_IN));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_LIKE));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_NOT_LIKE));
        }

        return operators;
    }

    @Override
    public OwCMISNativeFormat getFormat()
    {
        return new OwCMISNativeFormat(new OwCMISStringTransparentTextFormat(), String.class);
    }

    @Override
    public Object getDefaultValue() throws OwException
    {
        CmisPropertyHtmlDefinitionType nativeDef = (CmisPropertyHtmlDefinitionType) getNativeType();
        if (nativeDef.getDefaultValue() != null)
        {
            List<String> defValue = nativeDef.getDefaultValue().getValue();
            if (isArray())
            {
                return getConverterClass().toStaticArrayValue(defValue);
            }
            else
            {
                return getConverterClass().toStaticValue(defValue);
            }
        }
        else
        {
            return getDefaultValue();
        }
    }
}