package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIdDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISPropertyIdDefinition;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISStringTransparentTextFormat;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwSearchOperator;

/**
 *<p>
 * OwPropertyClass interface extending for CMIS property definition type Id.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyClassId<O> extends OwCMISNativePropertyClassTemplate<String, O>
{
    //private static final Logger LOG = OwLog.getLogger(OwCMISPropertyClassId.class);

    protected Collection<Integer> operators;

    public OwCMISPropertyClassId(CmisPropertyIdDefinitionType propertyDefinition_p, OwCMISValueConverterClass<String, O> valueConverter_p, OwCMISObjectClass objectClass_p)
    {
        this(propertyDefinition_p, valueConverter_p, objectClass_p, new OwCMISDynamicQuerySchema(propertyDefinition_p));
    }

    /**
     * Constructor to provide also the OwCMISNetworkConfiguration.
     * @param propertyDef
     * @param valueConverter
     * @param objClass
     * @param networkCfg
     * @since 4.0.0.1
     */
    public OwCMISPropertyClassId(CmisPropertyIdDefinitionType propertyDef, OwCMISValueConverterClass<String, O> valueConverter, OwCMISObjectClass objClass, OwCMISNetworkConfiguration networkCfg)
    {
        this(propertyDef, valueConverter, objClass, networkCfg, new OwCMISDynamicQuerySchema(propertyDef));
    }

    public OwCMISPropertyClassId(CmisPropertyIdDefinitionType propertyDefinition_p, OwCMISValueConverterClass<String, O> valueConverter_p, OwCMISObjectClass objectClass_p, OwCMISQuerySchema querySchema_p)
    {
        super(new OwCMISPropertyIdDefinition(propertyDefinition_p), valueConverter_p, objectClass_p, querySchema_p);
    }

    /**
     * Simple constructor to provide OwCMISQuerySchema
     * @param propertyDef
     * @param valueConverter
     * @param objClass
     * @param networkCfg
     * @param querySchema
     * @since 4.0.0.1
     */
    public OwCMISPropertyClassId(CmisPropertyIdDefinitionType propertyDef, OwCMISValueConverterClass<String, O> valueConverter, OwCMISObjectClass objClass, OwCMISNetworkConfiguration networkCfg, OwCMISQuerySchema querySchema)
    {
        super(new OwCMISPropertyIdDefinition(propertyDef), valueConverter, objClass, networkCfg, querySchema);
    }

    public synchronized Collection<Integer> getOperators() throws Exception
    {
        if (this.operators == null)
        {
            this.operators = new LinkedList<Integer>();
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_NOT_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_IS_IN));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_IS_NOT_IN));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_LIKE));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_NOT_LIKE));
        }

        return operators;
    }

    @Override
    public OwCMISNativeFormat getFormat()
    {
        return new OwCMISNativeFormat(new OwCMISStringTransparentTextFormat(), String.class);
    }

    @Override
    public Object getDefaultValue() throws OwException
    {
        CmisPropertyIdDefinitionType nativeDef = (CmisPropertyIdDefinitionType) getNativeType();
        if (nativeDef.getDefaultValue() != null)
        {
            List<String> defValue = nativeDef.getDefaultValue().getValue();
            if (isArray())
            {
                return getConverterClass().toStaticArrayValue(defValue);
            }
            else
            {
                return getConverterClass().toStaticValue(defValue);
            }
        }
        else
        {
            return super.getDefaultValue();
        }
    }
}
