package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIntegerDefinitionType;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISPropertyIntegerDefinition;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISBigIntegerTextFormat;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISSameTypeConverter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwSearchOperator;

/**
 *<p>
 * OwPropertyClass interface extending for CMIS property definition type Integer.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISPropertyClassInteger extends OwCMISNativePropertyClassTemplate<BigInteger, BigInteger>
{
    //private static final Logger LOG = OwLog.getLogger(OwCMISPropertyClassInteger.class);

    protected Collection<Integer> operators;

    public OwCMISPropertyClassInteger(CmisPropertyIntegerDefinitionType propertyDefinition_p, OwCMISObjectClass objectClass_p, OwCMISNetworkConfiguration networkCfg)
    {
        this(propertyDefinition_p, new OwCMISSameTypeConverter<BigInteger>(BigInteger.class), objectClass_p, networkCfg, new OwCMISDynamicQuerySchema(propertyDefinition_p));
    }

    /**
     * Simple constructor to provide specific OwCMISQuerySchema
     * @param propertyDef
     * @param objClass
     * @param networkCfg
     * @since 4.0.0.1
     */
    public OwCMISPropertyClassInteger(CmisPropertyIntegerDefinitionType propertyDef, OwCMISObjectClass objClass, OwCMISNetworkConfiguration networkCfg, OwCMISQuerySchema querySchema)
    {
        this(propertyDef, new OwCMISSameTypeConverter<BigInteger>(BigInteger.class), objClass, networkCfg, querySchema);
    }

    public OwCMISPropertyClassInteger(CmisPropertyIntegerDefinitionType propertyDefinition_p, OwCMISValueConverterClass<BigInteger, BigInteger> valueConverter_p, OwCMISObjectClass objectClass_p)
    {
        this(propertyDefinition_p, valueConverter_p, objectClass_p, null, new OwCMISDynamicQuerySchema(propertyDefinition_p));
    }

    public OwCMISPropertyClassInteger(CmisPropertyIntegerDefinitionType propertyDefinition_p, OwCMISValueConverterClass<BigInteger, BigInteger> valueConverter_p, OwCMISObjectClass objectClass_p, OwCMISNetworkConfiguration networkCfg,
            OwCMISQuerySchema querySchema_p)
    {
        super(new OwCMISPropertyIntegerDefinition(propertyDefinition_p), valueConverter_p, objectClass_p, networkCfg, querySchema_p);
    }

    public synchronized Collection<Integer> getOperators() throws Exception
    {
        if (this.operators == null)
        {

            this.operators = new LinkedList<Integer>();
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_NOT_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_LESS));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_LESS_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_GREATER));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_GREATER_EQUAL));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_IS_IN));
            this.operators.add(Integer.valueOf(OwSearchOperator.CRIT_OP_IS_NOT_IN));
        }

        return operators;
    }

    @Override
    public OwCMISNativeFormat getFormat()
    {
        return new OwCMISNativeFormat(new OwCMISBigIntegerTextFormat(), BigInteger.class);
    }

    @Override
    public Object getDefaultValue() throws OwException
    {
        CmisPropertyIntegerDefinitionType nativeDef = (CmisPropertyIntegerDefinitionType) getNativeType();
        if (nativeDef.getDefaultValue() != null)
        {
            List<BigInteger> defValue = nativeDef.getDefaultValue().getValue();
            if (isArray())
            {
                return getConverterClass().toStaticArrayValue(defValue);
            }
            else
            {
                return getConverterClass().toStaticValue(defValue);
            }
        }
        else
        {
            return super.getDefaultValue();
        }
    }
}