package com.wewebu.ow.server.ecmimpl.cmis.search;

import java.util.LinkedList;
import java.util.List;

import com.wewebu.ow.server.ecm.OwRepositoryContext;
import com.wewebu.ow.server.field.OwWildCardDefinition;

/**
 *<p>
 * Wild card's class, containing the list of available 
 * wild card definitions. Return a list of OwWildCardDefinition!
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISLikeWildcardDefinitions
{
    /**String representing wild card for multiple character*/
    public static final String MULTI_CHARACTER = "%";
    /**String representing wild card for single character*/
    public static final String SINGLE_CHARACTER = "_";

    private List<OwWildCardDefinition> definitionList;
    private OwRepositoryContext context;

    public OwCMISLikeWildcardDefinitions(OwRepositoryContext context_p)
    {
        this.context = context_p;
        init();
    }

    /**
     * Initialize the list of available wild cards.
     * <p>This method is called by the constructor.</p>
     */
    protected void init()
    {
        this.definitionList = new LinkedList<OwWildCardDefinition>();
        this.definitionList.add(new OwCMISWildCardDefinition(MULTI_CHARACTER, "search.OwCMISWildCardDefinition.WILD_CARD_TYPE_MULTI_CHAR", "(%1) replaces any characters", getRepositoryContext(), OwWildCardDefinition.WILD_CARD_TYPE_MULTI_CHAR));

        this.definitionList.add(new OwCMISWildCardDefinition(SINGLE_CHARACTER, "search.OwCMISWildCardDefinition.WILD_CARD_TYPE_SINGLE_CHAR", "(%1) replaces any character", getRepositoryContext(), OwWildCardDefinition.WILD_CARD_TYPE_SINGLE_CHAR));
    }

    /**
     * Return the list of defined/available wild cards
     * @return List of OwWildCardDefinition's
     */
    public List<OwWildCardDefinition> getWildCardDefinitions()
    {
        return this.definitionList;
    }

    /**
     * Get the context which was set during 
     * initialization of this object.
     * @return OwRepositoryContex
     */
    protected OwRepositoryContext getRepositoryContext()
    {
        return this.context;
    }
}