package com.wewebu.ow.server.ecmimpl.cmis.search;

import java.util.Locale;

import com.wewebu.ow.server.ecm.OwRepositoryContext;
import com.wewebu.ow.server.field.OwWildCardDefinition;

/**
 *<p>
 * Implementation of the OwWildCardDefinition interface for CMIS standard.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISWildCardDefinition implements OwWildCardDefinition
{

    private OwRepositoryContext repositoryContext;
    private String nativeWildCard;
    private int wildCardType;
    private String defaultLocalText;
    private String localizeID;

    public OwCMISWildCardDefinition(String nativeWildCard_p, String localizeID_p, String defaultLocalText_p, OwRepositoryContext context_p, int wildcardType_p)
    {
        this.repositoryContext = context_p;
        this.nativeWildCard = nativeWildCard_p;
        this.wildCardType = wildcardType_p;
        this.defaultLocalText = defaultLocalText_p;
        this.localizeID = localizeID_p;
    }

    public String getDescription(Locale locale_p)
    {
        return getRepositoryContext().localize1(getLocalizeID(), getDefaultLocalText(), getWildCard());
    }

    public String getNativeWildCard()
    {
        return this.nativeWildCard;
    }

    public int getType()
    {
        return this.wildCardType;
    }

    public String getWildCard()
    {
        return getRepositoryContext().getClientWildCard(getType());
    }

    /**
     * Getter for the current set repository context
     * @return OwRepositoryContext
     * @see OwRepositoryContext
     */
    protected OwRepositoryContext getRepositoryContext()
    {
        return this.repositoryContext;
    }

    /**
     * Getter for the default localized text.
     * @return String representing default localization
     */
    protected String getDefaultLocalText()
    {
        return this.defaultLocalText;
    }

    /**
     * Get the ID which is used for localization
     * of this wild card.
     * @return String representing localization key/id
     */
    protected String getLocalizeID()
    {
        return this.localizeID;
    }
}