package com.wewebu.ow.server.ecmimpl.cmis.ui;

import java.util.Map;

import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegesView;
import com.wewebu.ow.server.dmsdialogs.views.OwUIGenericAccessRightsModul;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.ui.acl.OwCMISPrivilegesView;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISAccessRightsModule which will provide depending 
 * on the configuration what selection will be available. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public class OwCMISAccessRightsModule extends OwUIGenericAccessRightsModul
{

    public OwCMISAccessRightsModule(OwCMISNetwork network, OwObject object, String policyViewTitle, String privilegesViewTitle, Map<String, String> privilegeDisplayNames, int privilegesOnly) throws OwException
    {
        super(network, object, policyViewTitle, privilegesViewTitle, privilegeDisplayNames, privilegesOnly);
    }

    @Override
    public OwCMISNetwork getNetwork()
    {
        return (OwCMISNetwork) super.getNetwork();
    }

    protected OwPrivilegesView createPrivilegesView() throws Exception
    {
        OwPrivilegesView owPrivilegesView = new OwCMISPrivilegesView(this, getPrivilegeDisplayNames(), getLiveUpdate());
        return owPrivilegesView;
    }
}
