package com.wewebu.ow.server.ecmimpl.cmis.ui;

import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.ui.OwUILoginModul;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISLoginInfoNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISSecurityHandlerInterface;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * OwCMISLoginSubModul.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISLoginSubModul extends OwUILoginModul
{
    /** Logger for this class */
    private static final Logger LOG = OwLog.getLogger(OwCMISLoginSubModul.class);

    /** temporary saves the login name */
    private String strUserName;

    /** render the view and all contained views
     * @param w_p Writer object to write HTML to
     */
    protected void onRender(Writer w_p) throws Exception
    {
        renderLoginForm(w_p);
    }

    public void init(OwCMISNetwork theNetwork_p) throws OwException
    {
        try
        {
            super.init(theNetwork_p);
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception ex)
        {
            LOG.fatal("OwCMISLoginSubModul.init(): Failed to initialize the CMIS login module", ex);
            throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISLoginSubModul.login.init.failed", "Failed to initialize the CMIS login module!"), ex);
        }
    }

    /** render the view and all contained views
     * @param w_p Writer object to write HTML to
     */
    protected void renderLoginForm(Writer w_p) throws Exception
    {
        // === enable return key for login
        getContext().registerKeyFormEvent(OwAppContext.KEYBOARD_KEY_RETURN, OwAppContext.KEYBOARD_CTRLKEY_NONE, getEventURL("Login", null), "loginForm", getContext().localize("cmis.ui.OwCMISLoginUISubModul.login", "Login"));

        // write the form
        w_p.write("<form name=\"loginForm\" method=\"post\" action=\"" + getEventURL("Login", null) + "\">\n");
        renderErrors(w_p);
        w_p.write("\n  <div class=\"OwLoginModule\">\n");
        w_p.write("    <div class=\"OwLoginModuleTitle\">\n      ");
        w_p.write(getContext().localize("cmis.ui.OwCMISLoginUISubModul.title", "CMIS Login"));
        w_p.write("\n    </div>\n    <div class=\"OwLoginModuleLogin\">\n       <div class=\"block blockLabel\">\n          <label for=\"loginNameId\">");
        w_p.write(getContext().localize("cmis.ui.OwCMISLoginUISubModul.name", "Name:"));
        w_p.write("</label>\n          <input id=\"loginNameId\" type=\"text\" size=\"30\" name=\"");
        w_p.write(OwCMISSecurityHandlerInterface.USER);
        w_p.write("\" ");
        w_p.write(strUserName == null ? "value=\"\" />" : "value=\"" + strUserName + "\"/>");
        w_p.write("\n          <label for=\"loginPasswordId\">");
        w_p.write(getContext().localize("cmis.ui.OwCMISLoginUISubModul.password", "Password:"));
        w_p.write("</label>\n          <input id=\"loginPasswordId\" type=\"password\" size=\"30\" name=\"");
        w_p.write(OwCMISSecurityHandlerInterface.PWD);
        w_p.write("\" />\n      </div>\n      <div class=\"block\">\n");
        // write the button for login
        w_p.write("          <input type=\"button\" onclick=\"document.loginForm.submit()\" value=\"");
        w_p.write(getContext().localize("cmis.ui.OwCMISLoginUISubModul.login", "Login"));
        w_p.write("\" />\n");
        // write the button for reset
        w_p.write("          <input type=\"button\" onclick=\"window.location.href ='");
        w_p.write(getEventURL("Reset", null));
        w_p.write("';\" onkeydown=\"return onKey(event,13,true,function(event){window.location.href='");
        w_p.write(getEventURL("Reset", null));
        w_p.write("';});\" value=\"");
        w_p.write(getContext().localize("cmis.ui.OwCMISLoginUISubModul.reset", "Reset"));
        w_p.write("\" />\n        </div>\n    </div>\n  </div>\n\n");
        w_p.write("</form>\n");

        // set focus to NAME element or if last name was restored to the password element, see Bug 874
        if ((strUserName != null) && (strUserName.length() > 0))
        {// forward to password, name has been restored from last trial
            getContext().setFocusControlID(OwCMISSecurityHandlerInterface.PWD);
        }
        else
        {
            getContext().setFocusControlID(OwCMISSecurityHandlerInterface.USER);
        }
    }

    /** event called when user pressed login in the login submodule 
     * @param request_p  a {@link HttpServletRequest}
     */
    public void onLogin(HttpServletRequest request_p) throws Exception
    {
        strUserName = request_p.getParameter(OwCMISSecurityHandlerInterface.USER);
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> enumeration = request_p.getHeaderNames();
        while (enumeration.hasMoreElements())
        {
            String attName = (String) enumeration.nextElement();
            map.put(attName, request_p.getHeader(attName));
        }

        enumeration = request_p.getParameterNames();
        while (enumeration.hasMoreElements())
        {
            String attName = (String) enumeration.nextElement();
            map.put(attName, request_p.getParameter(attName));
        }
        OwCMISLoginInfoNetwork network = (OwCMISLoginInfoNetwork) getNetwork();
        network.initLoginMap(map);
        // log user in
        getNetwork().loginDefault(strUserName, request_p.getParameter(OwCMISSecurityHandlerInterface.PWD));
    }

    /** event called when user pressed reset in the login submodule 
     * @param request_p a {@link HttpServletRequest}
     */
    public void onReset(HttpServletRequest request_p) throws Exception
    {
        // === Reset Login info
    }
}