package com.wewebu.ow.server.ecmimpl.cmis.ui.acl;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.app.OwUserSelectDialog;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegeSetEditor;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegeSetEditorDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegesDocument;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwDialog;

/**
 *<p>
 * Special privilege set editor, based on CMIS 
 * available permission and user selection.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public class OwCMISPrivilegeSetEditor extends OwPrivilegeSetEditor
{
    private static final Logger LOG = OwLog.getLogger(OwCMISPrivilegeSetEditor.class);

    public OwCMISPrivilegeSetEditor(OwPrivilegesDocument privilegesDocument_p, OwDialog dialog_p)
    {
        super(privilegesDocument_p, dialog_p);
    }

    @Override
    protected OwUserSelectDialog createOwUserSelectDialog(int[] filter, boolean multiSelect) throws OwException
    {
        OwRoleManagerContext roleCtx = getContext().getRegisteredInterface(OwRoleManagerContext.class);
        if (roleCtx != null)
        {
            OwNetwork network = roleCtx.getNetwork();
            try
            {
                if (network.canUserSelect())
                {
                    return super.createOwUserSelectDialog(filter, multiSelect);
                }
                else
                {
                    OwPrivilegeSetEditorDocument editorDocument = getDocument();

                    OwObject obj = editorDocument.getObject();
                    OwCMISResource res = (OwCMISResource) obj.getResource();
                    return new OwCMISSimpleUserSelectDialog(res.getRepositoryInfo());
                }
            }
            catch (Exception e)
            {
                LOG.error("Could not evaluate user selection of network", e);
                throw new OwServerException(getContext().localize("cmis.ui.acl.OwCMISPrivilegeSetEditor.createOwUserSelectDialog.error", "Evaluation of user selection failed."), e);
            }
        }
        else
        {
            return super.createOwUserSelectDialog(filter, multiSelect);
        }
    }

}
