package com.wewebu.ow.server.ecmimpl.cmis.ui.acl;

import java.util.Map;

import com.wewebu.ow.server.dmsdialogs.views.OwAddPrivilegeDialog;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegeSetEditor;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegesView;
import com.wewebu.ow.server.ecmimpl.cmis.ui.OwCMISAccessRightsModule;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Privileges view which has a special CMIS handling.
 * Will provide access to default CMIS privilege view
 * and editor implementation.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public class OwCMISPrivilegesView extends OwPrivilegesView
{
    public OwCMISPrivilegesView(OwCMISAccessRightsModule accessRightsView_p, Map<String, String> privilegeDisplayNames, boolean forceLiveUpdate)
    {
        super(accessRightsView_p, privilegeDisplayNames, forceLiveUpdate);
    }

    @Override
    protected void init() throws Exception
    {
        super.init();
        getDocument().attach(getContext(), getFormName());
    }

    @Override
    protected OwAddPrivilegeDialog createAddPrivilegeDialog() throws OwException
    {
        return new OwAddPrivilegeDialog(this) {
            protected OwPrivilegeSetEditor createPrivilegeSetEditor()
            {
                return new OwCMISPrivilegeSetEditor(getDocument(), this);
            }
        };
    }

    @Override
    public void detach()
    {
        super.detach();
        getDocument().detach();
    }

}
