package com.wewebu.ow.server.ecmimpl.cmis.ui.acl;

import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryInfoType;

import com.wewebu.ow.server.app.OwUserSelectDialog;
import com.wewebu.ow.server.util.OwHTMLHelper;

/**
 *<p>
 * Standard CMIS user selection dialog.
 * Returning only the users from RepositoryInfo object,
 * which is for CMIS V1.0 without LDAP the anonymous and anyone user.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public class OwCMISSimpleUserSelectDialog extends OwUserSelectDialog
{
    protected static final String USER_ID = "userId";
    private CmisRepositoryInfoType repositoryInfo;

    public OwCMISSimpleUserSelectDialog(CmisRepositoryInfoType repoType)
    {
        super(null, false);
        repositoryInfo = repoType;
    }

    @Override
    public void init() throws Exception
    {
        //super.init();
        setExternalFormTarget(this);
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception
    {
        if (iRegion_p == MAIN_REGION)
        {
            w_p.write("<div id=\"OwMainContent\" class=\"OwUIUserSelectModul OwCMISUserSelectModul\">\n");
            renderButton(w_p);
            w_p.write("</div>");
        }
        else
        {
            super.renderRegion(w_p, iRegion_p);
        }
    }

    protected void renderButton(Writer w_p) throws Exception
    {
        if (repositoryInfo.getPrincipalAnyone() != null)
        {
            w_p.write("<div><input type=\"radio\" name=\"");
            w_p.write(USER_ID);
            w_p.write("\" value=\"");
            String name = getContext().localize("cmis.acl.OwCMISSimpleUserSelectDialog.anyone", repositoryInfo.getPrincipalAnyone());
            name = OwHTMLHelper.encodeToSecureHTML(name);
            w_p.write(name);
            w_p.write("\">&nbsp;");
            w_p.write(name);
            w_p.write("</input></div><br>");
        }

        if (repositoryInfo.getPrincipalAnonymous() != null)
        {
            w_p.write("<div><input type=\"radio\" name=\"");
            w_p.write(USER_ID);
            w_p.write("\" value=\"");
            String name = getContext().localize("cmis.acl.OwCMISSimpleUserSelectDialog.anonym", repositoryInfo.getPrincipalAnonymous());
            name = OwHTMLHelper.encodeToSecureHTML(name);
            w_p.write(name);
            w_p.write("\">&nbsp;");
            w_p.write(name);
            w_p.write("</input></div><br>");
        }

        w_p.write("<div><input type=\"button\" value=\"");
        w_p.write(OwHTMLHelper.encodeToSecureHTML(getContext().localize("cmis.acl.OwCMISSimpleUserSelectDialog.btn.select", "Select")));
        w_p.write("\" onclick=\"");
        w_p.write(getFormEventURL("Select", null));
        w_p.write("\" /></div>");
    }

    @Override
    protected String usesFormWithAttributes()
    {
        return "";
    }

    public void onSelect(HttpServletRequest request_p) throws Exception
    {
        String user = request_p.getParameter(USER_ID);
        if (user != null)
        {
            List<String> lst = new LinkedList<String>();
            lst.add(user);
            onSelectRoles(lst);
        }
    }

}
