package com.wewebu.ow.server.ecmimpl.cmis.util;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

import javax.xml.datatype.XMLGregorianCalendar;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwDateTimeUtil;

/**
 *<p>
 * OwCMISStandardDateConverter.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISStandardDateConverter implements OwCMISValueConverter<XMLGregorianCalendar, Date>, OwCMISValueConverterClass<XMLGregorianCalendar, Date>
{
    private TimeZone timeZone;

    /**
     * @param timezone Timezone of the client
     * @since 3.1.0.3
     */
    public OwCMISStandardDateConverter(TimeZone timezone)
    {
        this.timeZone = timezone;
    }

    private XMLGregorianCalendar toXMLGregorianCalendar(Date date_p) throws OwInvalidOperationException
    {
        OwCMISDateTime cmisDateTime = new OwCMISDateTime(date_p);
        XMLGregorianCalendar xlmGCalendar = cmisDateTime.getXMLGregorianCalendar(true);
        xlmGCalendar.setTimezone(getTimeZone().getOffset(date_p.getTime()) / 60000);
        return xlmGCalendar;
    }

    private Date toDate(XMLGregorianCalendar xmlCalendar_p)
    {
        if (xmlCalendar_p == null)
        {
            return null;
        }
        else
        {
            OwCMISDateTime cmisDateTime = new OwCMISDateTime(xmlCalendar_p);
            TimeZone tzServer = xmlCalendar_p.getTimeZone(0);//UTC time offset 0
            return OwDateTimeUtil.convert(cmisDateTime.getDate(true), tzServer, getTimeZone());
        }
    }

    public List<XMLGregorianCalendar> fromArrayValue(Date[] owdValue_p) throws OwInvalidOperationException
    {
        if (owdValue_p != null)
        {
            List<XMLGregorianCalendar> cmisCalendarList = new LinkedList<XMLGregorianCalendar>();
            for (int i = 0; i < owdValue_p.length; i++)
            {
                XMLGregorianCalendar xlmGCalendar = toXMLGregorianCalendar(owdValue_p[i]);
                cmisCalendarList.add(xlmGCalendar);
            }
            return cmisCalendarList;
        }
        else
        {
            return new LinkedList<XMLGregorianCalendar>();
        }
    }

    public List<XMLGregorianCalendar> fromValue(Date owdValue_p) throws OwInvalidOperationException
    {
        List<XMLGregorianCalendar> cmisCalendarList = new LinkedList<XMLGregorianCalendar>();
        if (owdValue_p != null)
        {
            cmisCalendarList.add(toXMLGregorianCalendar(owdValue_p));
        }

        return cmisCalendarList;
    }

    public Date[] toArrayValue(List<XMLGregorianCalendar> cmisValue_p)
    {
        return toStaticArrayValue(cmisValue_p);
    }

    public Date toValue(List<XMLGregorianCalendar> cmisValue_p)
    {
        return toStaticValue(cmisValue_p);
    }

    public Class<Date> getOClass()
    {
        return Date.class;
    }

    public OwCMISValueConverter<XMLGregorianCalendar, Date> newConverter(OwCMISNetwork network_p)
    {
        return this;
    }

    public Date[] toStaticArrayValue(List<XMLGregorianCalendar> cmisValue_p)
    {
        if (cmisValue_p.isEmpty())
        {
            return null;
        }
        else
        {
            Date[] dateValues = new Date[cmisValue_p.size()];
            for (int i = 0; i < dateValues.length; i++)
            {
                XMLGregorianCalendar calendarValue = cmisValue_p.get(i);
                dateValues[i] = toDate(calendarValue);
            }
            return dateValues;
        }
    }

    public Date toStaticValue(List<XMLGregorianCalendar> cmisValue_p)
    {
        if (cmisValue_p.isEmpty())
        {
            return null;
        }
        else
        {
            return toDate(cmisValue_p.get(0));
        }
    }

    public OwCMISValueConverterClass<XMLGregorianCalendar, Date> getConverterClass()
    {
        return this;
    }

    /**
     * Time zone of the client, which can be used for conversion.
     * @return TimeZone of the client.
     * @since 3.1.0.3
     */
    protected TimeZone getTimeZone()
    {
        return this.timeZone;
    }

}
