package com.wewebu.ow.server.ecmimpl.cmis.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

/**
 *<p>
 *  Helper to compare two PropertyDefinition instances.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwPropertyDefinitionHelper
{

    /**
     * Compare base attributes of the property definition, if it is not returning on main checks 
     * the {@link #isInheritanceDifferent(CmisPropertyDefinitionType, CmisPropertyDefinitionType)} is invoked to
     * compare deeper. Compared are the attributes:<br />
     * <code>
     *  a.Id == b.Id;<br />
     *  a.type == b.type;<br />
     *  a.cardinality == b.cardinality;<br />
     *  a.queryName == b.queryName;
     * </code>
     * 
     * @param a CmisPropertyDefinitionType
     * @param b CmisPropertyDefinitionType
     * @return true if different
     */
    public static boolean isDifferent(CmisPropertyDefinitionType a, CmisPropertyDefinitionType b)
    {
        if (a.getId().equals(b.getId()))
        {
            if (a.getPropertyType().equals(b.getPropertyType()))
            {
                if (a.getCardinality().equals(b.getCardinality()))
                {
                    if (a.getQueryName() != null && b.getQueryName() != null)
                    {
                        if (a.getQueryName().equals(b.getQueryName()))
                        {
                            return isInheritanceDifferent(a, b);
                        }
                    }
                }
            }
        }
        return true;
    }

    /**
     * Assuming that the property definitions are linked somehow, or represent
     * an inheritance dependency, this method will check the other attributes
     * and tell if there are differences.
     * @param a CmisPropertyDefinitionType
     * @param b CmisPropertyDefinitionType
     * @return true if definition's are different, false else
     */
    public static boolean isInheritanceDifferent(CmisPropertyDefinitionType a, CmisPropertyDefinitionType b)
    {
        if (a.getUpdatability().equals(b.getUpdatability()))
        {
            if (a.isOrderable() == b.isOrderable())
            {
                if (a.isRequired() == b.isRequired())
                {
                    List<?> choicesA = getChoices(a);
                    List<?> choicesB = getChoices(b);
                    if ((choicesA == null || choicesA.isEmpty()) && (choicesB == null || choicesB.isEmpty()))
                    {
                        List<?> alst = getDefaultValue(a);
                        List<?> blst = getDefaultValue(b);
                        if (alst == null && blst == null)
                        {
                            return false;
                        }
                        else
                        {
                            if (alst != null && blst != null)
                            {
                                if (alst.size() == blst.size())
                                {
                                    return false;
                                }
                            }
                        }
                    }
                    else
                    {
                        if (choicesA != null && choicesB != null)
                        {
                            if ((a.isOpenChoice() != null && b.isOpenChoice() != null) && a.isOpenChoice().equals(b.isOpenChoice()))
                            {
                                List<?> aChoice = choicesA;
                                List<?> bChoice = choicesB;
                                if (aChoice.size() == bChoice.size())
                                {//Maybe incorrect since choices can be hierarchical
                                    return false;
                                }
                            }
                            else
                            {
                                if (a.isOpenChoice() == null && b.isOpenChoice() == null)
                                {
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private static List<?> getChoices(CmisPropertyDefinitionType a)
    {
        try
        {
            Method getChoicesM = a.getClass().getMethod("getChoice", new Class[] {});
            List<?> result = (List<?>) getChoicesM.invoke(a, new Object[] {});
            return result;
        }
        catch (SecurityException e)
        {
            return null;
        }
        catch (NoSuchMethodException e)
        {
            return null;
        }
        catch (IllegalArgumentException e)
        {
            return null;
        }
        catch (IllegalAccessException e)
        {
            return null;
        }
        catch (InvocationTargetException e)
        {
            return null;
        }
    }

    private static List<?> getDefaultValue(CmisPropertyDefinitionType a)
    {
        try
        {
            Method getChoicesM = a.getClass().getMethod("getDefaultValue", new Class[] {});
            Object def = getChoicesM.invoke(a, new Object[] {});
            if (null == def)
            {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(def);
            return result;
        }
        catch (SecurityException e)
        {
            return null;
        }
        catch (NoSuchMethodException e)
        {
            return null;
        }
        catch (IllegalArgumentException e)
        {
            return null;
        }
        catch (IllegalAccessException e)
        {
            return null;
        }
        catch (InvocationTargetException e)
        {
            return null;
        }
    }
}
