package com.wewebu.ow.server.ecmimpl.cmis.version;

import java.util.List;
import java.util.Set;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAllowableActionsType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyString;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningServicePort;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISContentConveter;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.broker.OwCMISObjectBroker;
import com.wewebu.ow.server.ecmimpl.cmis.content.OwCMISStandardContentConverter;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectExtension;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardPropertyCollectionConverter;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStaticProperty;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISContentHandler;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;

/**
 *<p>
 * OwCMISStandardVersion.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISStandardVersion implements OwVersion
{
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardVersion.class);

    private CmisObjectType cmisObject;
    private String repositoryId;
    private OwCMISNetwork network;

    public OwCMISStandardVersion(CmisObjectType cmisObject_p, OwCMISNetwork network_p, String repositoryId_p)
    {
        super();
        this.cmisObject = cmisObject_p;
        this.repositoryId = repositoryId_p;
        this.network = network_p;
    }

    public boolean canCancelcheckout(int context_p) throws OwException
    {
        if (isCheckedOut(context_p))
        {
            if (isMyCheckedOut(context_p))
            {
                CmisAllowableActionsType allowableActions = this.cmisObject.getAllowableActions();
                Boolean canCancelCheckOut = allowableActions.isCanCancelCheckOut();
                return canCancelCheckOut;
            }
            else
            {
                return false;
            }
        }
        else
        {
            return false;
        }

    }

    public boolean canCheckin(int contextStatus_p) throws OwException
    {
        if (isCheckedOut(contextStatus_p))
        {
            if (isMyCheckedOut(contextStatus_p))
            {
                CmisAllowableActionsType allowableActions = this.cmisObject.getAllowableActions();
                Boolean canCheckin = allowableActions.isCanCheckIn();
                return canCheckin;
            }
            else
            {
                return false;
            }

        }
        else
        {
            return false;
        }
    }

    public boolean canCheckout(int contextStatus_p) throws OwException
    {
        if (!isCheckedOut(contextStatus_p))
        {
            CmisAllowableActionsType allowableActions = this.cmisObject.getAllowableActions();
            Boolean canCheckout = allowableActions.isCanCheckOut();
            return canCheckout.booleanValue();
        }
        return false;
    }

    public boolean canDemote(int context_p) throws Exception
    {
        return false;
    }

    public boolean canPromote(int context_p) throws Exception
    {
        return false;
    }

    public boolean canSave(int contextStatus_p) throws OwException
    {
        return this.cmisObject.getAllowableActions().isCanSetContentStream() && this.isCheckedOut(contextStatus_p);
    }

    private String getVersionId() throws OwInvalidOperationException
    {
        String versionId = OwCMISPropertyNames.OBJECT_ID.getIdValue(this.cmisObject);
        return versionId;
    }

    private String getVersionSeriesId() throws OwInvalidOperationException
    {
        String versionSeriesId = OwCMISPropertyNames.VERSION_SERIES_ID.getIdValue(this.cmisObject);
        return versionSeriesId;
    }

    public void cancelcheckout() throws OwException
    {
        if (canCancelcheckout(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
        {
            VersioningServicePort versioningService = this.network.getVersionServicePort();

            try
            {
                String versionId = getVersionId();
                versioningService.cancelCheckOut(repositoryId, versionId, null);
                String versionSeriesId = getVersionSeriesId();

                OwCMISPropertiesFilter filter = new OwCMISPropertiesFilter();
                filter.add(OwCMISPropertyNames.OBJECT_ID.getId());
                filter.add(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());

                //                CmisObjectType currentVersion = versioningService.getObjectOfLatestVersion(this.repositoryId, versionSeriesId, false, filter.getFilterString(), true, EnumIncludeRelationships.NONE, null, false, false, null);

                List<CmisObjectType> allVersions = versioningService.getAllVersions(this.repositoryId, versionSeriesId, OwCMISStandardVersionModel.STANDARD_VERSION_FILTER, true, null);
                CmisObjectType currentVersion = allVersions.get(0);

                OwCMISObjectBroker broker = this.network.getObjectBroker();
                broker.versionCanceledChenckedOut(this.repositoryId, versionSeriesId, currentVersion, versionId);
            }
            catch (CmisException e)
            {
                OwNetworkContext context = this.network.getContext();
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                LOG.error("OwCMISStandardVersion.cancelcheckout(): Could not cancel the checkout state of the document! A CMIS error occurred : " + catcher.getLogMessage());
                throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.cancelcheckout.cmis.error", "Could not cancel the checkout state of the document!"), true);
            }
        }
        else
        {
            LOG.error("OwCMISStandardVersion.cancelcheckout(): The cancel-checkout operation is disabled for this object !");
            OwNetworkContext context = this.network.getContext();
            throw new OwInvalidOperationException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.cancelcheckout.disabled.error", "The cancel-checkout operation is disabled for this object !"));
        }

    }

    public void checkin(boolean fPromote_p, Object mode_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, boolean fOverwriteContent_p, String strMimeType_p,
            String strMimeParameter_p) throws OwException
    {
        if (canCheckin(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
        {

            VersioningServicePort versioningService = this.network.getVersionServicePort();

            try
            {
                Holder<String> versionId = new Holder<String>(getVersionId());

                CmisPropertiesType cmisProperties;

                if (properties_p != null && properties_p.size() > 0)
                {
                    OwCMISObject object = createObject();

                    OwCMISResource resource = this.network.getResource(this.repositoryId);

                    OwCMISObjectExtension objectExtension = resource.getExtension(OwCMISObjectBase.FILTER_PROPERTY_EXTENSIONS_EP, OwCMISObjectExtension.class, null);
                    OwPropertyCollection propertyExtensions = objectExtension.filterPropertyExtensions(resource, object.getClassName(), properties_p);

                    OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
                    properties.putAll(properties_p);
                    if (propertyExtensions != null)
                    {
                        Set extensionKeys = propertyExtensions.keySet();
                        for (Object extensionKey : extensionKeys)
                        {
                            properties.remove(extensionKey);
                        }
                    }

                    cmisProperties = new OwCMISStandardPropertyCollectionConverter().createCmisProperties(properties, object, object.getResourceID(), this.network);

                    objectExtension = resource.getExtension(OwCMISObjectBase.ADD_PROPERTY_EXTENSIONS_EP, OwCMISObjectExtension.class, cmisProperties);
                    cmisProperties = objectExtension.addPropertyExtensions(cmisProperties, propertyExtensions, object, resource.getID(), this.network);

                }
                else
                {
                    ObjectFactory cmisObjectFactory = new ObjectFactory();

                    cmisProperties = cmisObjectFactory.createCmisPropertiesType();
                }

                CmisContentStreamType cmisContentStream = new OwCMISStandardContentConverter().createCmisContentStream(content_p);
                BindingProvider bindingProvider = ((BindingProvider) versioningService);
                OwCMISContentHandler.setAttachmentToContext(cmisContentStream, bindingProvider);

                String checkInComment = "OWDCheckin_Comment";
                cmisProperties = processChangeToken(cmisProperties);
                versioningService.checkIn(this.repositoryId, versionId, fPromote_p, cmisProperties, cmisContentStream, checkInComment, null, null, null, null);

                CmisObjectType currentObject = getNewObject(versionId.value);
                OwCMISObjectBroker broker = this.network.getObjectBroker();
                broker.versionCheckedIn(this.repositoryId, getVersionSeriesId(), currentObject, getVersionId());
            }
            catch (CmisException e)
            {
                OwNetworkContext context = this.network.getContext();
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                LOG.error("OwCMISStandardVersion.checkin(): Could not checkin the document! A CMIS error occurred : " + catcher.getLogMessage());
                throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.checkin.cmis.error", "Could not checkin the document!"), true);
            }
        }
        else
        {
            LOG.error("OwCMISStandardVersion.checkin(): The checkin operation is disabled for this version!");
            OwNetworkContext context = this.network.getContext();
            throw new OwInvalidOperationException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.checkin.disabled.error", "The checkin operation is disabled for this object !"));
        }

    }

    public void checkout(Object mode_p) throws OwException
    {
        if (canCheckout(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
        {
            VersioningServicePort versioningService = this.network.getVersionServicePort();

            try
            {
                String versionSeriesId = getVersionSeriesId();
                Holder<String> vSeriesId = new Holder<String>(versionSeriesId);
                Holder<Boolean> contentCopied = new Holder<Boolean>(false);

                versioningService.checkOut(this.repositoryId, vSeriesId, null, contentCopied);

                CmisObjectType newObject = getNewObject(vSeriesId.value);
                OwCMISObjectBroker broker = this.network.getObjectBroker();
                broker.versionCheckedOut(this.repositoryId, versionSeriesId, newObject, getVersionId());
            }
            catch (CmisException e)
            {
                OwNetworkContext context = this.network.getContext();
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                LOG.error("OwCMISStandardVersion.checkout(): Could not checkout the document! A CMIS error occurred : " + catcher.getLogMessage());
                throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.checkout.cmis.error", "Could not checkout the document!"), true);
            }
        }
        else
        {
            LOG.error("OwCMISStandardVersion.checkout():The checkout operation is disabled this object!");
            OwNetworkContext context = this.network.getContext();
            throw new OwInvalidOperationException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.checkout.disabled.error", "The checkout operation is disabled for this object !"));

        }
    }

    public void demote() throws Exception
    {
        // TODO Auto-generated method stub

    }

    public boolean equals(OwVersion version_p) throws Exception
    {
        if (version_p instanceof OwCMISStandardVersion)
        {
            OwCMISStandardVersion stdVersion = (OwCMISStandardVersion) version_p;
            return getVersionId().equals(stdVersion.getVersionId());
        }
        else
        {
            return false;
        }
    }

    public String getCheckedOutUserID(int context_p) throws Exception
    {
        String versionCheckedOutBy = OwCMISPropertyNames.VERSION_SERIES_CHECKED_OUT_BY.getStringValue(this.cmisObject);
        if (versionCheckedOutBy != null)
        {
            //TODO:get user ID from user name
            return versionCheckedOutBy;

        }
        else
        {
            return null;
        }
    }

    public String getVersionInfo() throws OwException
    {
        String versionLabel = OwCMISPropertyNames.VERSION_LABEL.getStringValue(this.cmisObject);
        return versionLabel;
    }

    public int[] getVersionNumber() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    public boolean isCheckedOut(int contextStatus_p) throws OwException
    {
        return OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getBooleanValue(this.cmisObject);
    }

    public boolean isLatest(int contextStatus_p) throws OwException
    {
        Boolean latestVersion = OwCMISPropertyNames.IS_LATEST_VERSION.getBooleanValue(this.cmisObject);
        return latestVersion;
    }

    public boolean isMajor(int contextStatus_p) throws OwException
    {
        Boolean majorVersion = OwCMISPropertyNames.IS_MAJOR_VERSION.getBooleanValue(this.cmisObject);
        return majorVersion;
    }

    private String getCurrentUserName() throws OwException
    {
        OwCMISCredentials credentials = this.network.getCredentials();
        try
        {
            OwCMISUserInfo userInfo = credentials.getUserInfo();
            return userInfo.getUserName();
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            String msg = "Could not retrieve the currenc user info!";
            LOG.error("OwCMISStandardVersion.getCurrentUserInfo():" + msg, e);
            throw new OwInvalidOperationException(msg, e);
        }
    }

    public boolean isMyCheckedOut(int contextStatus_p) throws OwException
    {
        if (isCheckedOut(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
        {
            String owner = OwCMISPropertyNames.VERSION_SERIES_CHECKED_OUT_BY.getStringValue(this.cmisObject);
            String userName = getCurrentUserName();
            return userName != null && owner != null && userName.equals(owner.toString());
        }
        else
        {
            return false;
        }
    }

    public boolean isReleased(int contextStatus_p) throws OwException
    {
        return isMajor(contextStatus_p);
    }

    public void promote() throws Exception
    {
        // TODO Auto-generated method stub

    }

    public void save(OwContentCollection contentCol_p, String strMimeType_p, String strMimeParameter_p) throws OwException
    {
        if (canSave(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
        {
            ObjectServicePort objectService = this.network.getObjectServicePort();
            String oldVersionId = getVersionId();
            Holder<String> objectIdHolder = new Holder<String>(oldVersionId);
            CmisPropertyString prop = getChangeToken();
            Holder<String> changeTokenHolder = new Holder<String>(OwCMISStaticProperty.getStringValue(prop));
            OwCMISContentConveter converter = new OwCMISStandardContentConverter();
            CmisContentStreamType contentStream = converter.createCmisContentStream(contentCol_p);
            try
            {
                BindingProvider bindingProvider = ((BindingProvider) objectService);
                OwCMISContentHandler.setAttachmentToContext(contentStream, bindingProvider);

                objectService.setContentStream(this.repositoryId, objectIdHolder, true, changeTokenHolder, contentStream, null);
                CmisObjectType currentObject = getNewObject(objectIdHolder.value);
                OwCMISObjectBroker broker = this.network.getObjectBroker();
                broker.versionSaved(this.repositoryId, getVersionId(), currentObject, oldVersionId);
            }
            catch (CmisException e)
            {
                OwNetworkContext context = this.network.getContext();
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                LOG.error("OwCMISStandardVersion.save(): Could not save the document! A CMIS error occurred : " + catcher.getLogMessage());
                throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.save.cmis.error", "Could not save the document!"), true);
            }
        }
        else
        {
            LOG.error("OwCMISStandardVersion.save():Saving content for this version is disabled!");
            OwNetworkContext context = this.network.getContext();
            throw new OwInvalidOperationException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.save.disabled.error", "Saving content for this version is disabled!"));
        }
    }

    private CmisObjectType getNewObject(String newId_p) throws OwException
    {
        ObjectServicePort objectService = this.network.getObjectServicePort();
        try
        {
            return objectService.getObject(this.repositoryId, newId_p, OwCMISStandardVersionModel.STANDARD_VERSION_FILTER, Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
        }
        catch (CmisException e)
        {
            OwNetworkContext context = this.network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISStandardVersion.getNewObject(): Could not retrieve the new object! A CMIS error occurred : " + catcher.getLogMessage());
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.getNewObject.cmis.error", "Could not retrieve the new object!"), true);
        }
    }

    public OwCMISObject createObject() throws OwException
    {
        OwCMISResource resource = this.network.getResource(this.repositoryId);
        return this.network.createCMISObject(this.cmisObject, resource);
    }

    /**
     * Helper to get the cmis:changeToken definition.
     * Will first check the local object for occurrence and
     * if is missing will retrieve from CMIS repository (round-trip).
     * @return CmisPropertyString representing the cmis:changeToken
     * @throws OwException
     */
    protected CmisPropertyString getChangeToken() throws OwException
    {
        CmisPropertyString val = (CmisPropertyString) OwCMISPropertyNames.CHANGE_TOKEN.fromPropertyList(cmisObject.getProperties().getProperty());

        try
        {
            if (val == null)
            {
                ObjectServicePort objectService = this.network.getObjectServicePort();
                CmisPropertiesType type = objectService.getProperties(repositoryId, getVersionId(), OwCMISPropertyNames.CHANGE_TOKEN.getId(), null);
                val = (CmisPropertyString) OwCMISPropertyNames.CHANGE_TOKEN.fromPropertyList(type.getProperty());
            }

            return val;
        }
        catch (CmisException e)
        {
            OwNetworkContext context = this.network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("Failed to retrieve changeToken! A CMIS error occurred : " + catcher.getLogMessage());
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersion.getChangeToken.error", "ChangeToken retrieval could not be processed successfully!"), true);
        }
    }

    /**
     * Process the CMIS properties for changeToken like specified in CMIS 1.0.
     * @param cmisProperties CmisPropertiesType to work on
     * @return CmisPropertiesType w/o changeToken property
     * @throws OwException
     * @since 3.2.0.1
     */
    protected CmisPropertiesType processChangeToken(CmisPropertiesType cmisProperties) throws OwException
    {
        CmisPropertyString changeToken = (CmisPropertyString) OwCMISPropertyNames.CHANGE_TOKEN.fromPropertyList(cmisProperties.getProperty());
        if (changeToken == null)
        {
            changeToken = getChangeToken();
            if (changeToken != null && !changeToken.getValue().isEmpty())
            {
                cmisProperties.getProperty().add(changeToken);
            }
        }
        else
        {
            if (changeToken.getValue().isEmpty())
            {
                cmisProperties.getProperty().remove(changeToken);
            }
        }
        return cmisProperties;
    }
}
