package com.wewebu.ow.server.ecmimpl.cmis.version;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningServicePort;

import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISDocumentObject;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwRuntimeException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * OwCMISStandardVersionSeries.
 * Implementation of the OwVersionSeries specific to the CMIS wrapping.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@see OwVersionSeries
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class OwCMISStandardVersionSeries implements OwVersionSeries
{
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardVersionSeries.class);

    private OwCMISDocumentObject documentObject;
    private OwCMISNetwork network;

    public OwCMISStandardVersionSeries(OwCMISDocumentObject documentObject_p, OwCMISNetwork network_p)
    {
        super();
        this.documentObject = documentObject_p;
        this.network = network_p;
    }

    private OwVersion getLatestVersion(boolean major_p) throws OwException
    {
        VersioningServicePort versionServicePort = this.network.getVersionServicePort();

        CmisObjectType latestVersion = null;
        try
        {
            String repositoryId = documentObject.getResourceID();
            String versionSeriesId = this.documentObject.getVersionSeriesId();
            latestVersion = versionServicePort.getObjectOfLatestVersion(repositoryId, versionSeriesId, major_p, OwCMISStandardVersionModel.STANDARD_VERSION_FILTER, true, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
            return new OwCMISStandardVersion(latestVersion, this.network, repositoryId);
        }
        catch (CmisException e)
        {
            OwNetworkContext context = this.network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISStandardVersionModel.getLatestVersion(): Could not retrieve a latest version! A CMIS error occurred : " + catcher.getLogMessage());
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersionModel.createVersion.cmis.error", "Could not create version!"), true);
        }

    }

    public OwVersion getLatest() throws Exception
    {
        try
        {
            OwVersion latest = getLatestVersion(false);
            //            if (!latest.isMyCheckedOut(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
            //            {
            //                List<OwCMISStandardVersion> allVersions = getVersions(null, null, 0);
            //
            //                return allVersions.get(0);
            //            }

            //default 
            return latest;
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            String msg = "Could not retrieve the latest version !";
            LOG.error("OwCMISStandardVersionSeries.getLatest():" + msg, e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardVersionModel.createVersion.cmis.error", "Could not create version!"), e);
        }
    }

    public OwCMISObject getObject(OwVersion version_p) throws Exception
    {
        if (version_p instanceof OwCMISStandardVersion)
        {
            OwCMISStandardVersion standardVersion = (OwCMISStandardVersion) version_p;
            return standardVersion.createObject();
        }
        else
        {
            String msg = "Invalid version java-class " + version_p.getClass() + " !";
            LOG.error("OwCMISStandardVersionSeries.getObject():" + msg);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardVersionSeries.version.error", "Workdesk version error!"));
        }
    }

    public OwVersion getReleased() throws Exception
    {
        return getLatestVersion(true);
    }

    public OwVersion getReservation() throws Exception
    {
        OwVersion latest = getLatest();
        if (latest.isMyCheckedOut(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
        {
            return latest;
        }
        else
        {
            return null;
        }
    }

    public List<OwCMISStandardVersion> getVersions(Collection properties_p, OwSort sort_p, int maxSize_p) throws OwException
    {
        VersioningServicePort versionServicePort = this.network.getVersionServicePort();
        try
        {
            String versionSeriesId = this.documentObject.getVersionSeriesId();
            String repositoryId = this.documentObject.getResourceID();
            List<OwCMISStandardVersion> allOWDVersions = new LinkedList<OwCMISStandardVersion>();

            String propsReq = OwCMISStandardVersionModel.STANDARD_VERSION_FILTER;
            if (properties_p != null)
            {
                OwCMISPropertiesFilter filter = new OwCMISPropertiesFilter();
                filter.addAll(OwCMISQueryContext.GET_PROPERTY, properties_p, documentObject.getObjectClass(), documentObject.getResource());
                propsReq = propsReq + "," + filter.getFilterString();
            }

            List<CmisObjectType> allVersions = versionServicePort.getAllVersions(repositoryId, versionSeriesId, propsReq, true, null);

            for (CmisObjectType cmisVersion : allVersions)
            {
                OwCMISStandardVersion owdVersion = new OwCMISStandardVersion(cmisVersion, this.network, repositoryId);
                allOWDVersions.add(owdVersion);
            }

            //            if (allOWDVersions.size() > 0)
            //            {
            //                OwVersion firstVersion = allOWDVersions.get(0);
            //                if (firstVersion.isCheckedOut(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS) && !firstVersion.isMyCheckedOut(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
            //                {
            //                    allOWDVersions.remove(0);
            //                }
            //            }

            return allOWDVersions;
        }
        catch (CmisException e)
        {
            OwNetworkContext context = this.network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error("OwCMISStandardVersionSeries.getVersions(): Could not retrieve versions! A CMIS error occurred : " + catcher.getLogMessage());
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersionSeries.getVersions.cmis.error", "Could retrieve versions!"), true);
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISVersionSeries.getVersions(): Could not retrieve  versions!", e);
            throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISStandardVersionSeries.getVersions.cmis.error", "Could retrieve versions!"), e);
        }
    }

    public String getId()
    {
        try
        {
            return this.documentObject.getVersionSeriesId();
        }
        catch (OwException e)
        {
            throw new OwRuntimeException("Could not retrieve VersionSeries ID", e) {

                private static final long serialVersionUID = 1L;

                @Override
                public String getModulName()
                {
                    return "cmis";
                }
            };
        }
    }
}
