package com.wewebu.ow.server.ecmimpl.cmis.version;

import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;

import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISDocumentObject;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISVersionModel.
 * Interface for classes which will work as factory of version objects.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISVersionModel
{
    /**
     * Helper interface to retrieve the newest version of the native CmisObjectType.
     * @param network_p OwCMISNetwork to use for additional request
     * @param repositoryId_p String representing the repository ID
     * @param cmisObject_p CmisObjectType
     * @return CmisObjectType which could be updated
     * @throws OwException
     */
    CmisObjectType retriveOWDObjectVersion(OwCMISNetwork network_p, String repositoryId_p, CmisObjectType cmisObject_p) throws OwException;

    /**
     * Create an instance from given parameters, which implements the OwVersionSeries interface.
     * @param documentObject_p OwCMISDocumentObject for which the version series should be created
     * @param network_p OwCMISNetwork which should be used for additional requests
     * @return OwVersionSeries depending on the given parameters
     * @throws OwException
     * @see OwVersionSeries
     */
    OwVersionSeries createVersionSeries(OwCMISDocumentObject documentObject_p, OwCMISNetwork network_p) throws OwException;

    /**
     * Create the specific version depending on the given document object.
     * @param network_p OwCMISNetwork to be used for additional request
     * @param documentObject_p OwCMISDocumentObject from which the specific OwVersion must be created
     * @return OwVersion representing the version of given document object
     * @throws OwException
     */
    OwVersion createVersion(OwCMISNetwork network_p, OwCMISDocumentObject documentObject_p) throws OwException;
}
