package com.wewebu.ow.server.ecmimpl.cmis.wshandler;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;

import com.wewebu.ow.server.ecmimpl.cmis.content.OwCMISContentElementDataSource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;

/**
 *<p>
 * Default content handler.
 * A SOAPHandler which will create a SOAP-Message,
 * where content is provided as SOAP-Attachment (http://www.w3.org/TR/SOAP-attachments).
 * The SOAP-Attachment is defined as XOP http://www.w3.org/2004/08/xop/include element.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public class OwCMISContentHandler implements SOAPHandler<SOAPMessageContext>
{
    private static final Logger LOG = OwLog.getLogger(OwCMISContentHandler.class);
    /**
     * Set this system property to true if you want to skip using the Big SOAP Attachment workaround. The default value is false.</br> 
     * See {@link #handleMessage(SOAPMessageContext)}
     */
    public static final String SYS_PROP_OWD_CMIS_SKIPMETROSOAPATTACHMENTFIX = "owd.cmis.skipMetroSOAPAttachmentFix";

    public static boolean isSkipMetroSOAPAttachmentFix()
    {
        boolean result = Boolean.getBoolean(SYS_PROP_OWD_CMIS_SKIPMETROSOAPATTACHMENTFIX);
        return result;
    }

    public Set<QName> getHeaders()
    {
        return null;
    }

    public void close(MessageContext msgCtx_p)
    {

    }

    public boolean handleFault(SOAPMessageContext msgCtx_p)
    {
        return false;
    }

    /**
     * Workaround for OutOfMemoryError when sending big Attachments with Metro JAX-WS RI. 
     */
    public boolean handleMessage(SOAPMessageContext msgCtx_p)
    {
        if (Boolean.TRUE.equals(msgCtx_p.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY)))
        {
            try
            {
                if (!OwCMISContentHandler.isSkipMetroSOAPAttachmentFix() && processContent(msgCtx_p) && msgCtx_p.containsKey(OwCMISContentElementDataSource.DATASOURCE_CONTENT_KEY))
                {
                    SOAPMessage soapMessage;
                    DataHandler dh = (DataHandler) msgCtx_p.get(OwCMISContentElementDataSource.DATASOURCE_CONTENT_KEY);
                    try
                    {
                        soapMessage = msgCtx_p.getMessage();
                        AttachmentPart attPart = soapMessage.createAttachmentPart(dh);
                        String attachID = Long.toHexString(System.currentTimeMillis()) + "@alfresco.com";

                        attPart.setContentId(attachID);
                        SOAPBody body = soapMessage.getSOAPBody();
                        SOAPElement elem = (SOAPElement) body.getFirstChild();
                        Iterator<?> it = elem.getChildElements();
                        while (it.hasNext())
                        {
                            elem = (SOAPElement) it.next();
                            if (elem.getLocalName().equals("contentStream"))
                            {
                                break;
                            }
                        }
                        if (elem.getPrefix() == null)
                        {//prefix must not exist, if CMIS-Namespace is default namespace
                            elem = elem.addChildElement(new QName(elem.getNamespaceURI(), "stream"));
                        }
                        else
                        {
                            elem = elem.addChildElement(new QName(elem.getNamespaceURI(), "stream", elem.getPrefix()));
                        }
                        //<xop:Include xmlns:xop="http://www.w3.org/2004/08/xop/include" href="cid:HexAttachmentString@alfresco.com" />
                        elem = elem.addChildElement(new QName("http://www.w3.org/2004/08/xop/include", "Include", "xop"));
                        elem.addNamespaceDeclaration("xop", "http://www.w3.org/2004/08/xop/include");
                        elem.addAttribute(new QName("href"), "cid:" + attachID);

                        soapMessage.addAttachmentPart(attPart);
                        msgCtx_p.remove(OwCMISContentElementDataSource.DATASOURCE_CONTENT_KEY);
                    }
                    catch (SOAPException soapEx)
                    {
                        msgCtx_p.remove(OwCMISContentElementDataSource.DATASOURCE_CONTENT_KEY);
                        LOG.error("Could not create SOAP Attachment", soapEx);
                        return Boolean.FALSE.booleanValue();
                    }
                }
            }
            catch (SOAPException soapEx)
            {
                LOG.error("Could not request SOAP operation, processing for content stopped!", soapEx);
                return false;
            }
        }
        return Boolean.TRUE.booleanValue();
    }

    /**
     * Return all method names where the content is provided.
     * @return String with the method names
     */
    protected String getMethods()
    {
        return "createDocument, setContentStream, checkIn";
    }

    /**
     * Method which check if a content processing is needed for that call.
     * @param msgCtx_p SOAPMessageContext current context
     * @return boolean true if handling should be done
     * @throws SOAPException
     * @since 3.2.0.0
     */
    protected boolean processContent(SOAPMessageContext msgCtx_p) throws SOAPException
    {
        QName qnMethod = (QName) msgCtx_p.get(MessageContext.WSDL_OPERATION);
        if (qnMethod != null)
        {
            return getMethods().contains(qnMethod.getLocalPart());
        }
        else
        {//workaround for non-patched 1.6 environment
            SOAPMessage soapMessage = msgCtx_p.getMessage();
            return getMethods().contains(soapMessage.getSOAPBody().getFirstChild().getLocalName());
        }
    }

    public static void setAttachmentToContext(CmisContentStreamType content_p, BindingProvider bindingProvider)
    {
        if (OwCMISContentHandler.isSkipMetroSOAPAttachmentFix())
        {
            //Do nothing
            return;
        }
        Map<String, Object> map = bindingProvider.getRequestContext();
        if (content_p != null)
        {
            DataHandler dh = content_p.getStream();
            map.put(OwCMISContentElementDataSource.DATASOURCE_CONTENT_KEY, dh);
            content_p.setStream(null);
        }
        else
        {
            if (map.containsKey(OwCMISContentElementDataSource.DATASOURCE_CONTENT_KEY))
            {
                map.remove(OwCMISContentElementDataSource.DATASOURCE_CONTENT_KEY);
            }
        }
    }
}