package com.wewebu.ow.server.ecmimpl.cmis.wshandler;

import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

/**
 *<p>
 * Extended Security Handler interface for web service communication.<br/>
 * This Interface extends the SOAPHandler&lt;SOAPMessageContex&gt; interface
 * to provide additional information for the <a href="http://www.w3.org/TR/ws-i18n/">
 * W3C definition of WS-i18n</a> extension.
 * <br/><br/>
 * Keep in mind that the implementing class must have a default constructor.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public interface OwCMISSecurityHandlerInterface extends SOAPHandler<SOAPMessageContext>
{
    /**User name key for init map*/
    public static final String USER = "username";
    /**password key for init map*/
    public static final String PWD = "password";

    /**URI of the web service security extension*/
    public static String WS_SECEXT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    /**URI of the web service security utility*/
    public static String WS_SECUTILITY = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    /**URI of the web service security user name token profile 1.0*/
    public static String WS_USER_TOKEN_PROFILE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0";
    /**URI for the international support in web services*/
    public static String WS_I18N = "http://www.w3.org/2005/09/ws-i18n";
    /**prefix for security extension: wsse*/
    public static String WS_SECEXT_PREFIX = "wsse";
    /**prefix for security utility: wsu*/
    public static String WS_SECUTILITY_PREFIX = "wsu";
    /**prefix for internationalization: i18n*/
    public static String WS_I18N_PREFIX = "i18n";

    /**
     * Set the Locale which should be provided
     * for WS-i18n localization. Remember that the locale should be used
     * with the <a href="http://www.w3.org/TR/ws-i18n/#sec-locale">LDML definitions</a>
     *  if added to the SOAP header.
     * @param locale_p Locale to be used, or null
     */
    void setLocale(Locale locale_p);

    /**
     * Return the defined Locale which should
     * be used by for the SOAP WS-i18n header.
     * Can return null to avoid the attaching/creation of the
     * web service localization header. 
     * @return Locale or null
     */
    Locale getLocale();

    /**
     * Set the String which should represent the value of the
     * time zone web service header. 
     * The String should be regarding the <a href="http://www.w3.org/TR/ws-i18n/#sec-tz">
     * W3C definition of WS-i18n</a> specification.
     * <p>deprecated since 4.0.0.0 use {@link #setWsi18nTimeZone(TimeZone)} or {@link #setWsi18nTimeZone(String)} instead</p>
     * @param timeZone_p String can be null.
     * @deprecated since 4.0.0.0 use {@link #setWsi18nTimeZone(TimeZone)} or {@link #setWsi18nTimeZone(String)} instead
     */
    @Deprecated
    void setTimezoneString(String timeZone_p);

    /**
     * Transform the provided Timezone into a string 
     * which should be used for WSI communication with CMIS system.
     * @param timeZone_p TimeZone can be null.
     * @since 4.0.0.0
     * @see #setWsi18nTimeZone(String)
     */
    void setWsi18nTimeZone(TimeZone timeZone_p);

    /**
     * Set the String which should represent the value of the
     * time zone web service header. 
     * The String should be regarding the <a href="http://www.w3.org/TR/ws-i18n/#sec-tz">
     * W3C definition of WS-i18n</a> specification.
     * @param timeZone_p String can be null.
     * @since 4.0.0.0
     */
    void setWsi18nTimeZone(String timeZone_p);

    /**
     * Return the Time zone String which should be used in web services
     * header. Can return null, if the time zone web service header should not
     * be added.
     * @return String or null
     * @deprecated since 4.0.0.0 use {@link #getWsi18nTimeZone()} instead
     */
    @Deprecated
    String getTimezoneString();

    /**
     * Return the Time zone String which should be used in web services
     * header. Can return null, if the time zone web service header should not
     * be added.<br />
     * For further information see <a href="http://www.w3.org/TR/ws-i18n/#sec-tz">
     * W3C definition of WS-i18n</a>.
     * @return String or null
     */
    String getWsi18nTimeZone();

    /**
     * Initial method which is called after instantiation of the Security handler.
     * Provided are HTTP headers and also USERNAME and USERPASSWORD for simple authentication. 
     * @param arr_p Map Strings header to value mapping
     */
    void init(Map<String, String> arr_p);
}